package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KMSKeyReferenceBuilder extends KMSKeyReferenceFluentImpl<KMSKeyReferenceBuilder> implements VisitableBuilder<KMSKeyReference,KMSKeyReferenceBuilder>{
  public KMSKeyReferenceBuilder() {
    this(false);
  }
  public KMSKeyReferenceBuilder(Boolean validationEnabled) {
    this(new KMSKeyReference(), validationEnabled);
  }
  public KMSKeyReferenceBuilder(KMSKeyReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public KMSKeyReferenceBuilder(KMSKeyReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KMSKeyReference(), validationEnabled);
  }
  public KMSKeyReferenceBuilder(KMSKeyReferenceFluent<?> fluent,KMSKeyReference instance) {
    this(fluent, instance, false);
  }
  public KMSKeyReferenceBuilder(KMSKeyReferenceFluent<?> fluent,KMSKeyReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKeyRing(instance.getKeyRing()); 
    fluent.withLocation(instance.getLocation()); 
    fluent.withName(instance.getName()); 
    fluent.withProjectID(instance.getProjectID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KMSKeyReferenceBuilder(KMSKeyReference instance) {
    this(instance,false);
  }
  public KMSKeyReferenceBuilder(KMSKeyReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withKeyRing(instance.getKeyRing()); 
    this.withLocation(instance.getLocation()); 
    this.withName(instance.getName()); 
    this.withProjectID(instance.getProjectID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  KMSKeyReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public KMSKeyReference build() {
    KMSKeyReference buildable = new KMSKeyReference(fluent.getKeyRing(),fluent.getLocation(),fluent.getName(),fluent.getProjectID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}