package io.fabric8.openshift.api.model.installer.baremetal.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HostFluentImpl<A extends HostFluent<A>> extends BaseFluent<A> implements HostFluent<A>{
  public HostFluentImpl() {
  }
  public HostFluentImpl(Host instance) {
    this.withBmc(instance.getBmc()); 
    this.withBootMACAddress(instance.getBootMACAddress()); 
    this.withBootMode(instance.getBootMode()); 
    this.withHardwareProfile(instance.getHardwareProfile()); 
    this.withName(instance.getName()); 
    this.withNetworkConfig(instance.getNetworkConfig()); 
    this.withRole(instance.getRole()); 
    this.withRootDeviceHints(instance.getRootDeviceHints()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private BMCBuilder bmc;
  private String bootMACAddress;
  private String bootMode;
  private String hardwareProfile;
  private String name;
  private String networkConfig;
  private String role;
  private RootDeviceHintsBuilder rootDeviceHints;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildBmc instead.
   * @return The buildable object.
   */
  @Deprecated
  public BMC getBmc() {
    return this.bmc!=null ?this.bmc.build():null;
  }
  public BMC buildBmc() {
    return this.bmc!=null ?this.bmc.build():null;
  }
  public A withBmc(BMC bmc) {
    _visitables.get("bmc").remove(this.bmc);
    if (bmc!=null){ this.bmc= new BMCBuilder(bmc); _visitables.get("bmc").add(this.bmc);} else { this.bmc = null; _visitables.get("bmc").remove(this.bmc); } return (A) this;
  }
  public Boolean hasBmc() {
    return this.bmc != null;
  }
  public A withNewBmc(String address,Boolean disableCertificateVerification,String password,String username) {
    return (A)withBmc(new BMC(address, disableCertificateVerification, password, username));
  }
  public HostFluent.BmcNested<A> withNewBmc() {
    return new HostFluentImpl.BmcNestedImpl();
  }
  public HostFluent.BmcNested<A> withNewBmcLike(BMC item) {
    return new HostFluentImpl.BmcNestedImpl(item);
  }
  public HostFluent.BmcNested<A> editBmc() {
    return withNewBmcLike(getBmc());
  }
  public HostFluent.BmcNested<A> editOrNewBmc() {
    return withNewBmcLike(getBmc() != null ? getBmc(): new BMCBuilder().build());
  }
  public HostFluent.BmcNested<A> editOrNewBmcLike(BMC item) {
    return withNewBmcLike(getBmc() != null ? getBmc(): item);
  }
  public String getBootMACAddress() {
    return this.bootMACAddress;
  }
  public A withBootMACAddress(String bootMACAddress) {
    this.bootMACAddress=bootMACAddress; return (A) this;
  }
  public Boolean hasBootMACAddress() {
    return this.bootMACAddress != null;
  }
  public String getBootMode() {
    return this.bootMode;
  }
  public A withBootMode(String bootMode) {
    this.bootMode=bootMode; return (A) this;
  }
  public Boolean hasBootMode() {
    return this.bootMode != null;
  }
  public String getHardwareProfile() {
    return this.hardwareProfile;
  }
  public A withHardwareProfile(String hardwareProfile) {
    this.hardwareProfile=hardwareProfile; return (A) this;
  }
  public Boolean hasHardwareProfile() {
    return this.hardwareProfile != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public String getNetworkConfig() {
    return this.networkConfig;
  }
  public A withNetworkConfig(String networkConfig) {
    this.networkConfig=networkConfig; return (A) this;
  }
  public Boolean hasNetworkConfig() {
    return this.networkConfig != null;
  }
  public String getRole() {
    return this.role;
  }
  public A withRole(String role) {
    this.role=role; return (A) this;
  }
  public Boolean hasRole() {
    return this.role != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRootDeviceHints instead.
   * @return The buildable object.
   */
  @Deprecated
  public RootDeviceHints getRootDeviceHints() {
    return this.rootDeviceHints!=null ?this.rootDeviceHints.build():null;
  }
  public RootDeviceHints buildRootDeviceHints() {
    return this.rootDeviceHints!=null ?this.rootDeviceHints.build():null;
  }
  public A withRootDeviceHints(RootDeviceHints rootDeviceHints) {
    _visitables.get("rootDeviceHints").remove(this.rootDeviceHints);
    if (rootDeviceHints!=null){ this.rootDeviceHints= new RootDeviceHintsBuilder(rootDeviceHints); _visitables.get("rootDeviceHints").add(this.rootDeviceHints);} else { this.rootDeviceHints = null; _visitables.get("rootDeviceHints").remove(this.rootDeviceHints); } return (A) this;
  }
  public Boolean hasRootDeviceHints() {
    return this.rootDeviceHints != null;
  }
  public HostFluent.RootDeviceHintsNested<A> withNewRootDeviceHints() {
    return new HostFluentImpl.RootDeviceHintsNestedImpl();
  }
  public HostFluent.RootDeviceHintsNested<A> withNewRootDeviceHintsLike(RootDeviceHints item) {
    return new HostFluentImpl.RootDeviceHintsNestedImpl(item);
  }
  public HostFluent.RootDeviceHintsNested<A> editRootDeviceHints() {
    return withNewRootDeviceHintsLike(getRootDeviceHints());
  }
  public HostFluent.RootDeviceHintsNested<A> editOrNewRootDeviceHints() {
    return withNewRootDeviceHintsLike(getRootDeviceHints() != null ? getRootDeviceHints(): new RootDeviceHintsBuilder().build());
  }
  public HostFluent.RootDeviceHintsNested<A> editOrNewRootDeviceHintsLike(RootDeviceHints item) {
    return withNewRootDeviceHintsLike(getRootDeviceHints() != null ? getRootDeviceHints(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HostFluentImpl that = (HostFluentImpl) o;
    if (bmc != null ? !bmc.equals(that.bmc) :that.bmc != null) return false;
    if (bootMACAddress != null ? !bootMACAddress.equals(that.bootMACAddress) :that.bootMACAddress != null) return false;
    if (bootMode != null ? !bootMode.equals(that.bootMode) :that.bootMode != null) return false;
    if (hardwareProfile != null ? !hardwareProfile.equals(that.hardwareProfile) :that.hardwareProfile != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (networkConfig != null ? !networkConfig.equals(that.networkConfig) :that.networkConfig != null) return false;
    if (role != null ? !role.equals(that.role) :that.role != null) return false;
    if (rootDeviceHints != null ? !rootDeviceHints.equals(that.rootDeviceHints) :that.rootDeviceHints != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bmc,  bootMACAddress,  bootMode,  hardwareProfile,  name,  networkConfig,  role,  rootDeviceHints,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bmc != null) { sb.append("bmc:"); sb.append(bmc + ","); }
    if (bootMACAddress != null) { sb.append("bootMACAddress:"); sb.append(bootMACAddress + ","); }
    if (bootMode != null) { sb.append("bootMode:"); sb.append(bootMode + ","); }
    if (hardwareProfile != null) { sb.append("hardwareProfile:"); sb.append(hardwareProfile + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (networkConfig != null) { sb.append("networkConfig:"); sb.append(networkConfig + ","); }
    if (role != null) { sb.append("role:"); sb.append(role + ","); }
    if (rootDeviceHints != null) { sb.append("rootDeviceHints:"); sb.append(rootDeviceHints + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class BmcNestedImpl<N> extends BMCFluentImpl<HostFluent.BmcNested<N>> implements HostFluent.BmcNested<N>,Nested<N>{
    BmcNestedImpl(BMC item) {
      this.builder = new BMCBuilder(this, item);
    }
    BmcNestedImpl() {
      this.builder = new BMCBuilder(this);
    }
    BMCBuilder builder;
    public N and() {
      return (N) HostFluentImpl.this.withBmc(builder.build());
    }
    public N endBmc() {
      return and();
    }
    
  }
  class RootDeviceHintsNestedImpl<N> extends RootDeviceHintsFluentImpl<HostFluent.RootDeviceHintsNested<N>> implements HostFluent.RootDeviceHintsNested<N>,Nested<N>{
    RootDeviceHintsNestedImpl(RootDeviceHints item) {
      this.builder = new RootDeviceHintsBuilder(this, item);
    }
    RootDeviceHintsNestedImpl() {
      this.builder = new RootDeviceHintsBuilder(this);
    }
    RootDeviceHintsBuilder builder;
    public N and() {
      return (N) HostFluentImpl.this.withRootDeviceHints(builder.build());
    }
    public N endRootDeviceHints() {
      return and();
    }
    
  }
  
}