package io.fabric8.openshift.api.model.installer.aws.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>> extends BaseFluent<A> implements MachinePoolFluent<A>{
  public MachinePoolFluentImpl() {
  }
  public MachinePoolFluentImpl(MachinePool instance) {
    this.withAmiID(instance.getAmiID()); 
    this.withIamRole(instance.getIamRole()); 
    this.withRootVolume(instance.getRootVolume()); 
    this.withType(instance.getType()); 
    this.withZones(instance.getZones()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String amiID;
  private String iamRole;
  private EC2RootVolumeBuilder rootVolume;
  private String type;
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public String getAmiID() {
    return this.amiID;
  }
  public A withAmiID(String amiID) {
    this.amiID=amiID; return (A) this;
  }
  public Boolean hasAmiID() {
    return this.amiID != null;
  }
  public String getIamRole() {
    return this.iamRole;
  }
  public A withIamRole(String iamRole) {
    this.iamRole=iamRole; return (A) this;
  }
  public Boolean hasIamRole() {
    return this.iamRole != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRootVolume instead.
   * @return The buildable object.
   */
  @Deprecated
  public EC2RootVolume getRootVolume() {
    return this.rootVolume!=null ?this.rootVolume.build():null;
  }
  public EC2RootVolume buildRootVolume() {
    return this.rootVolume!=null ?this.rootVolume.build():null;
  }
  public A withRootVolume(EC2RootVolume rootVolume) {
    _visitables.get("rootVolume").remove(this.rootVolume);
    if (rootVolume!=null){ this.rootVolume= new EC2RootVolumeBuilder(rootVolume); _visitables.get("rootVolume").add(this.rootVolume);} else { this.rootVolume = null; _visitables.get("rootVolume").remove(this.rootVolume); } return (A) this;
  }
  public Boolean hasRootVolume() {
    return this.rootVolume != null;
  }
  public A withNewRootVolume(Integer iops,String kmsKeyARN,Integer size,String type) {
    return (A)withRootVolume(new EC2RootVolume(iops, kmsKeyARN, size, type));
  }
  public MachinePoolFluent.RootVolumeNested<A> withNewRootVolume() {
    return new MachinePoolFluentImpl.RootVolumeNestedImpl();
  }
  public MachinePoolFluent.RootVolumeNested<A> withNewRootVolumeLike(EC2RootVolume item) {
    return new MachinePoolFluentImpl.RootVolumeNestedImpl(item);
  }
  public MachinePoolFluent.RootVolumeNested<A> editRootVolume() {
    return withNewRootVolumeLike(getRootVolume());
  }
  public MachinePoolFluent.RootVolumeNested<A> editOrNewRootVolume() {
    return withNewRootVolumeLike(getRootVolume() != null ? getRootVolume(): new EC2RootVolumeBuilder().build());
  }
  public MachinePoolFluent.RootVolumeNested<A> editOrNewRootVolumeLike(EC2RootVolume item) {
    return withNewRootVolumeLike(getRootVolume() != null ? getRootVolume(): item);
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToZones(Integer index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  public A setToZones(Integer index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A removeFromZones(java.lang.String... items) {
    for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
  }
  public A removeAllFromZones(Collection<String> items) {
    for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
  }
  public List<String> getZones() {
    return this.zones;
  }
  public String getZone(Integer index) {
    return this.zones.get(index);
  }
  public String getFirstZone() {
    return this.zones.get(0);
  }
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  public String getMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withZones(List<String> zones) {
    if (zones != null) {this.zones = new ArrayList(); for (String item : zones){this.addToZones(item);}} else { this.zones = null;} return (A) this;
  }
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {this.zones.clear();}
    if (zones != null) {for (String item :zones){ this.addToZones(item);}} return (A) this;
  }
  public Boolean hasZones() {
    return zones != null && !zones.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MachinePoolFluentImpl that = (MachinePoolFluentImpl) o;
    if (amiID != null ? !amiID.equals(that.amiID) :that.amiID != null) return false;
    if (iamRole != null ? !iamRole.equals(that.iamRole) :that.iamRole != null) return false;
    if (rootVolume != null ? !rootVolume.equals(that.rootVolume) :that.rootVolume != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (zones != null ? !zones.equals(that.zones) :that.zones != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(amiID,  iamRole,  rootVolume,  type,  zones,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (amiID != null) { sb.append("amiID:"); sb.append(amiID + ","); }
    if (iamRole != null) { sb.append("iamRole:"); sb.append(iamRole + ","); }
    if (rootVolume != null) { sb.append("rootVolume:"); sb.append(rootVolume + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class RootVolumeNestedImpl<N> extends EC2RootVolumeFluentImpl<MachinePoolFluent.RootVolumeNested<N>> implements MachinePoolFluent.RootVolumeNested<N>,Nested<N>{
    RootVolumeNestedImpl(EC2RootVolume item) {
      this.builder = new EC2RootVolumeBuilder(this, item);
    }
    RootVolumeNestedImpl() {
      this.builder = new EC2RootVolumeBuilder(this);
    }
    EC2RootVolumeBuilder builder;
    public N and() {
      return (N) MachinePoolFluentImpl.this.withRootVolume(builder.build());
    }
    public N endRootVolume() {
      return and();
    }
    
  }
  
}