package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VCenterBuilder extends VCenterFluent<VCenterBuilder> implements VisitableBuilder<VCenter,VCenterBuilder>{
  public VCenterBuilder() {
    this(new VCenter());
  }
  
  public VCenterBuilder(VCenterFluent<?> fluent) {
    this(fluent, new VCenter());
  }
  
  public VCenterBuilder(VCenterFluent<?> fluent,VCenter instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VCenterBuilder(VCenter instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VCenterFluent<?> fluent;
  
  public VCenter build() {
    VCenter buildable = new VCenter(fluent.getDatacenters(),fluent.getPassword(),fluent.getPort(),fluent.getServer(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}