package io.fabric8.openshift.api.model.installer.alibabacloud.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PlatformBuilder extends PlatformFluent<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(new Platform());
  }
  
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, new Platform());
  }
  
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PlatformBuilder(Platform instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PlatformFluent<?> fluent;
  
  public Platform build() {
    Platform buildable = new Platform(fluent.buildDefaultMachinePlatform(),fluent.getPrivateZoneID(),fluent.getRegion(),fluent.getResourceGroupID(),fluent.getTags(),fluent.getVpcID(),fluent.getVswitchIDs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}