/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.openstack.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.openstack.v1.MachinePool;
import io.fabric8.openshift.api.model.hive.openstack.v1.RootVolume;
import io.fabric8.openshift.api.model.hive.openstack.v1.RootVolumeBuilder;
import io.fabric8.openshift.api.model.hive.openstack.v1.RootVolumeFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String flavor;
    private RootVolumeBuilder rootVolume;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public RootVolume buildRootVolume() {
        return this.rootVolume != null ? this.rootVolume.build() : null;
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withFlavor(instance.getFlavor());
            this.withRootVolume(instance.getRootVolume());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public RootVolumeNested<A> editOrNewRootVolume() {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(new RootVolumeBuilder().build()));
    }

    public RootVolumeNested<A> editOrNewRootVolumeLike(RootVolume item) {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(item));
    }

    public RootVolumeNested<A> editRootVolume() {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)((Object)o);
        if (!Objects.equals(this.flavor, that.flavor)) {
            return false;
        }
        if (!Objects.equals((Object)this.rootVolume, (Object)that.rootVolume)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasFlavor() {
        return this.flavor != null;
    }

    public boolean hasRootVolume() {
        return this.rootVolume != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.flavor, this.rootVolume, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.flavor != null) {
            sb.append("flavor:");
            sb.append(this.flavor);
            sb.append(",");
        }
        if (this.rootVolume != null) {
            sb.append("rootVolume:");
            sb.append((Object)this.rootVolume);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withFlavor(String flavor) {
        this.flavor = flavor;
        return (A)((Object)this);
    }

    public RootVolumeNested<A> withNewRootVolume() {
        return new RootVolumeNested(null);
    }

    public A withNewRootVolume(Integer size, String type) {
        return this.withRootVolume(new RootVolume(size, type));
    }

    public RootVolumeNested<A> withNewRootVolumeLike(RootVolume item) {
        return new RootVolumeNested(item);
    }

    public A withRootVolume(RootVolume rootVolume) {
        this._visitables.remove((Object)"rootVolume");
        if (rootVolume != null) {
            this.rootVolume = new RootVolumeBuilder(rootVolume);
            this._visitables.get((Object)"rootVolume").add(this.rootVolume);
        } else {
            this.rootVolume = null;
            this._visitables.get((Object)"rootVolume").remove((Object)this.rootVolume);
        }
        return (A)((Object)this);
    }

    public class RootVolumeNested<N>
    extends RootVolumeFluent<RootVolumeNested<N>>
    implements Nested<N> {
        RootVolumeBuilder builder;

        RootVolumeNested(RootVolume item) {
            this.builder = new RootVolumeBuilder(this, item);
        }

        public N and() {
            return (N)MachinePoolFluent.this.withRootVolume(this.builder.build());
        }

        public N endRootVolume() {
            return this.and();
        }
    }
}

