/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.openshift.api.model.hive.v1.ControllerConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ControllerConfigFluent<A extends ControllerConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Integer clientBurst;
    private Integer clientQPS;
    private Integer concurrentReconciles;
    private Integer queueBurst;
    private Integer queueQPS;
    private Integer replicas;
    private ResourceRequirementsBuilder resources;

    public ControllerConfigFluent() {
    }

    public ControllerConfigFluent(ControllerConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    protected void copyInstance(ControllerConfig instance) {
        ControllerConfig controllerConfig = instance = instance != null ? instance : new ControllerConfig();
        if (instance != null) {
            this.withClientBurst(instance.getClientBurst());
            this.withClientQPS(instance.getClientQPS());
            this.withConcurrentReconciles(instance.getConcurrentReconciles());
            this.withQueueBurst(instance.getQueueBurst());
            this.withQueueQPS(instance.getQueueQPS());
            this.withReplicas(instance.getReplicas());
            this.withResources(instance.getResources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ControllerConfigFluent that = (ControllerConfigFluent)((Object)o);
        if (!Objects.equals(this.clientBurst, that.clientBurst)) {
            return false;
        }
        if (!Objects.equals(this.clientQPS, that.clientQPS)) {
            return false;
        }
        if (!Objects.equals(this.concurrentReconciles, that.concurrentReconciles)) {
            return false;
        }
        if (!Objects.equals(this.queueBurst, that.queueBurst)) {
            return false;
        }
        if (!Objects.equals(this.queueQPS, that.queueQPS)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getClientBurst() {
        return this.clientBurst;
    }

    public Integer getClientQPS() {
        return this.clientQPS;
    }

    public Integer getConcurrentReconciles() {
        return this.concurrentReconciles;
    }

    public Integer getQueueBurst() {
        return this.queueBurst;
    }

    public Integer getQueueQPS() {
        return this.queueQPS;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasClientBurst() {
        return this.clientBurst != null;
    }

    public boolean hasClientQPS() {
        return this.clientQPS != null;
    }

    public boolean hasConcurrentReconciles() {
        return this.concurrentReconciles != null;
    }

    public boolean hasQueueBurst() {
        return this.queueBurst != null;
    }

    public boolean hasQueueQPS() {
        return this.queueQPS != null;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public int hashCode() {
        return Objects.hash(this.clientBurst, this.clientQPS, this.concurrentReconciles, this.queueBurst, this.queueQPS, this.replicas, this.resources, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientBurst != null) {
            sb.append("clientBurst:");
            sb.append(this.clientBurst);
            sb.append(",");
        }
        if (this.clientQPS != null) {
            sb.append("clientQPS:");
            sb.append(this.clientQPS);
            sb.append(",");
        }
        if (this.concurrentReconciles != null) {
            sb.append("concurrentReconciles:");
            sb.append(this.concurrentReconciles);
            sb.append(",");
        }
        if (this.queueBurst != null) {
            sb.append("queueBurst:");
            sb.append(this.queueBurst);
            sb.append(",");
        }
        if (this.queueQPS != null) {
            sb.append("queueQPS:");
            sb.append(this.queueQPS);
            sb.append(",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas);
            sb.append(",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withClientBurst(Integer clientBurst) {
        this.clientBurst = clientBurst;
        return (A)((Object)this);
    }

    public A withClientQPS(Integer clientQPS) {
        this.clientQPS = clientQPS;
        return (A)((Object)this);
    }

    public A withConcurrentReconciles(Integer concurrentReconciles) {
        this.concurrentReconciles = concurrentReconciles;
        return (A)((Object)this);
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public A withQueueBurst(Integer queueBurst) {
        this.queueBurst = queueBurst;
        return (A)((Object)this);
    }

    public A withQueueQPS(Integer queueQPS) {
        this.queueQPS = queueQPS;
        return (A)((Object)this);
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove(this.resources);
        }
        return (A)((Object)this);
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder((ResourceRequirementsFluent)this, item);
        }

        public N and() {
            return (N)ControllerConfigFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }
}

