/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.aws.v1.PlatformStatus;
import io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatus;
import io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatusBuilder;
import io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatusFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PlatformStatusFluent<A extends PlatformStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private PrivateLinkAccessStatusBuilder privateLink;

    public PlatformStatusFluent() {
    }

    public PlatformStatusFluent(PlatformStatus instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public PrivateLinkAccessStatus buildPrivateLink() {
        return this.privateLink != null ? this.privateLink.build() : null;
    }

    protected void copyInstance(PlatformStatus instance) {
        PlatformStatus platformStatus = instance = instance != null ? instance : new PlatformStatus();
        if (instance != null) {
            this.withPrivateLink(instance.getPrivateLink());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PrivateLinkNested<A> editOrNewPrivateLink() {
        return this.withNewPrivateLinkLike(Optional.ofNullable(this.buildPrivateLink()).orElse(new PrivateLinkAccessStatusBuilder().build()));
    }

    public PrivateLinkNested<A> editOrNewPrivateLinkLike(PrivateLinkAccessStatus item) {
        return this.withNewPrivateLinkLike(Optional.ofNullable(this.buildPrivateLink()).orElse(item));
    }

    public PrivateLinkNested<A> editPrivateLink() {
        return this.withNewPrivateLinkLike(Optional.ofNullable(this.buildPrivateLink()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformStatusFluent that = (PlatformStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.privateLink, (Object)that.privateLink)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasPrivateLink() {
        return this.privateLink != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.privateLink, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.privateLink != null) {
            sb.append("privateLink:");
            sb.append((Object)this.privateLink);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public PrivateLinkNested<A> withNewPrivateLink() {
        return new PrivateLinkNested(null);
    }

    public PrivateLinkNested<A> withNewPrivateLinkLike(PrivateLinkAccessStatus item) {
        return new PrivateLinkNested(item);
    }

    public A withPrivateLink(PrivateLinkAccessStatus privateLink) {
        this._visitables.remove((Object)"privateLink");
        if (privateLink != null) {
            this.privateLink = new PrivateLinkAccessStatusBuilder(privateLink);
            this._visitables.get((Object)"privateLink").add(this.privateLink);
        } else {
            this.privateLink = null;
            this._visitables.get((Object)"privateLink").remove((Object)this.privateLink);
        }
        return (A)((Object)this);
    }

    public class PrivateLinkNested<N>
    extends PrivateLinkAccessStatusFluent<PrivateLinkNested<N>>
    implements Nested<N> {
        PrivateLinkAccessStatusBuilder builder;

        PrivateLinkNested(PrivateLinkAccessStatus item) {
            this.builder = new PrivateLinkAccessStatusBuilder(this, item);
        }

        public N and() {
            return (N)PlatformStatusFluent.this.withPrivateLink(this.builder.build());
        }

        public N endPrivateLink() {
            return this.and();
        }
    }
}

