package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelectorSyncSetBuilder extends SelectorSyncSetFluentImpl<SelectorSyncSetBuilder> implements VisitableBuilder<SelectorSyncSet,SelectorSyncSetBuilder>{
  public SelectorSyncSetBuilder() {
    this(false);
  }
  public SelectorSyncSetBuilder(Boolean validationEnabled) {
    this(new SelectorSyncSet(), validationEnabled);
  }
  public SelectorSyncSetBuilder(SelectorSyncSetFluent<?> fluent) {
    this(fluent, false);
  }
  public SelectorSyncSetBuilder(SelectorSyncSetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SelectorSyncSet(), validationEnabled);
  }
  public SelectorSyncSetBuilder(SelectorSyncSetFluent<?> fluent,SelectorSyncSet instance) {
    this(fluent, instance, false);
  }
  public SelectorSyncSetBuilder(SelectorSyncSetFluent<?> fluent,SelectorSyncSet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SelectorSyncSetBuilder(SelectorSyncSet instance) {
    this(instance,false);
  }
  public SelectorSyncSetBuilder(SelectorSyncSet instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SelectorSyncSetFluent<?> fluent;
  Boolean validationEnabled;
  public SelectorSyncSet build() {
    SelectorSyncSet buildable = new SelectorSyncSet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}