package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachinePoolStatusFluentImpl<A extends MachinePoolStatusFluent<A>> extends BaseFluent<A> implements MachinePoolStatusFluent<A>{
  public MachinePoolStatusFluentImpl() {
  }
  public MachinePoolStatusFluentImpl(MachinePoolStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withMachineSets(instance.getMachineSets()); 
    this.withReplicas(instance.getReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<MachinePoolConditionBuilder> conditions = new ArrayList<MachinePoolConditionBuilder>();
  private ArrayList<MachineSetStatusBuilder> machineSets = new ArrayList<MachineSetStatusBuilder>();
  private Integer replicas;
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,MachinePoolCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachinePoolConditionBuilder>();}
    MachinePoolConditionBuilder builder = new MachinePoolConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,MachinePoolCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachinePoolConditionBuilder>();}
    MachinePoolConditionBuilder builder = new MachinePoolConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.hive.v1.MachinePoolCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachinePoolConditionBuilder>();}
    for (MachinePoolCondition item : items) {MachinePoolConditionBuilder builder = new MachinePoolConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<MachinePoolCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<MachinePoolConditionBuilder>();}
    for (MachinePoolCondition item : items) {MachinePoolConditionBuilder builder = new MachinePoolConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.hive.v1.MachinePoolCondition... items) {
    for (MachinePoolCondition item : items) {MachinePoolConditionBuilder builder = new MachinePoolConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<MachinePoolCondition> items) {
    for (MachinePoolCondition item : items) {MachinePoolConditionBuilder builder = new MachinePoolConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<MachinePoolConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<MachinePoolConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      MachinePoolConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MachinePoolCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<MachinePoolCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public MachinePoolCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public MachinePoolCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public MachinePoolCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public MachinePoolCondition buildMatchingCondition(Predicate<MachinePoolConditionBuilder> predicate) {
    for (MachinePoolConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<MachinePoolConditionBuilder> predicate) {
    for (MachinePoolConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<MachinePoolCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (MachinePoolCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.hive.v1.MachinePoolCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (MachinePoolCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public MachinePoolStatusFluent.ConditionsNested<A> addNewCondition() {
    return new MachinePoolStatusFluentImpl.ConditionsNestedImpl();
  }
  public MachinePoolStatusFluent.ConditionsNested<A> addNewConditionLike(MachinePoolCondition item) {
    return new MachinePoolStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public MachinePoolStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,MachinePoolCondition item) {
    return new MachinePoolStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public MachinePoolStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public MachinePoolStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public MachinePoolStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public MachinePoolStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<MachinePoolConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public A addToMachineSets(Integer index,MachineSetStatus item) {
    if (this.machineSets == null) {this.machineSets = new ArrayList<MachineSetStatusBuilder>();}
    MachineSetStatusBuilder builder = new MachineSetStatusBuilder(item);_visitables.get("machineSets").add(index >= 0 ? index : _visitables.get("machineSets").size(), builder);this.machineSets.add(index >= 0 ? index : machineSets.size(), builder); return (A)this;
  }
  public A setToMachineSets(Integer index,MachineSetStatus item) {
    if (this.machineSets == null) {this.machineSets = new ArrayList<MachineSetStatusBuilder>();}
    MachineSetStatusBuilder builder = new MachineSetStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("machineSets").size()) { _visitables.get("machineSets").add(builder); } else { _visitables.get("machineSets").set(index, builder);}
    if (index < 0 || index >= machineSets.size()) { machineSets.add(builder); } else { machineSets.set(index, builder);}
     return (A)this;
  }
  public A addToMachineSets(io.fabric8.openshift.api.model.hive.v1.MachineSetStatus... items) {
    if (this.machineSets == null) {this.machineSets = new ArrayList<MachineSetStatusBuilder>();}
    for (MachineSetStatus item : items) {MachineSetStatusBuilder builder = new MachineSetStatusBuilder(item);_visitables.get("machineSets").add(builder);this.machineSets.add(builder);} return (A)this;
  }
  public A addAllToMachineSets(Collection<MachineSetStatus> items) {
    if (this.machineSets == null) {this.machineSets = new ArrayList<MachineSetStatusBuilder>();}
    for (MachineSetStatus item : items) {MachineSetStatusBuilder builder = new MachineSetStatusBuilder(item);_visitables.get("machineSets").add(builder);this.machineSets.add(builder);} return (A)this;
  }
  public A removeFromMachineSets(io.fabric8.openshift.api.model.hive.v1.MachineSetStatus... items) {
    for (MachineSetStatus item : items) {MachineSetStatusBuilder builder = new MachineSetStatusBuilder(item);_visitables.get("machineSets").remove(builder);if (this.machineSets != null) {this.machineSets.remove(builder);}} return (A)this;
  }
  public A removeAllFromMachineSets(Collection<MachineSetStatus> items) {
    for (MachineSetStatus item : items) {MachineSetStatusBuilder builder = new MachineSetStatusBuilder(item);_visitables.get("machineSets").remove(builder);if (this.machineSets != null) {this.machineSets.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMachineSets(Predicate<MachineSetStatusBuilder> predicate) {
    if (machineSets == null) return (A) this;
    final Iterator<MachineSetStatusBuilder> each = machineSets.iterator();
    final List visitables = _visitables.get("machineSets");
    while (each.hasNext()) {
      MachineSetStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMachineSets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MachineSetStatus> getMachineSets() {
    return machineSets != null ? build(machineSets) : null;
  }
  public List<MachineSetStatus> buildMachineSets() {
    return machineSets != null ? build(machineSets) : null;
  }
  public MachineSetStatus buildMachineSet(Integer index) {
    return this.machineSets.get(index).build();
  }
  public MachineSetStatus buildFirstMachineSet() {
    return this.machineSets.get(0).build();
  }
  public MachineSetStatus buildLastMachineSet() {
    return this.machineSets.get(machineSets.size() - 1).build();
  }
  public MachineSetStatus buildMatchingMachineSet(Predicate<MachineSetStatusBuilder> predicate) {
    for (MachineSetStatusBuilder item: machineSets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMachineSet(Predicate<MachineSetStatusBuilder> predicate) {
    for (MachineSetStatusBuilder item: machineSets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMachineSets(List<MachineSetStatus> machineSets) {
    if (this.machineSets != null) { _visitables.get("machineSets").removeAll(this.machineSets);}
    if (machineSets != null) {this.machineSets = new ArrayList(); for (MachineSetStatus item : machineSets){this.addToMachineSets(item);}} else { this.machineSets = null;} return (A) this;
  }
  public A withMachineSets(io.fabric8.openshift.api.model.hive.v1.MachineSetStatus... machineSets) {
    if (this.machineSets != null) {this.machineSets.clear();}
    if (machineSets != null) {for (MachineSetStatus item :machineSets){ this.addToMachineSets(item);}} return (A) this;
  }
  public Boolean hasMachineSets() {
    return machineSets != null && !machineSets.isEmpty();
  }
  public MachinePoolStatusFluent.MachineSetsNested<A> addNewMachineSet() {
    return new MachinePoolStatusFluentImpl.MachineSetsNestedImpl();
  }
  public MachinePoolStatusFluent.MachineSetsNested<A> addNewMachineSetLike(MachineSetStatus item) {
    return new MachinePoolStatusFluentImpl.MachineSetsNestedImpl(-1, item);
  }
  public MachinePoolStatusFluent.MachineSetsNested<A> setNewMachineSetLike(Integer index,MachineSetStatus item) {
    return new MachinePoolStatusFluentImpl.MachineSetsNestedImpl(index, item);
  }
  public MachinePoolStatusFluent.MachineSetsNested<A> editMachineSet(Integer index) {
    if (machineSets.size() <= index) throw new RuntimeException("Can't edit machineSets. Index exceeds size.");
    return setNewMachineSetLike(index, buildMachineSet(index));
  }
  public MachinePoolStatusFluent.MachineSetsNested<A> editFirstMachineSet() {
    if (machineSets.size() == 0) throw new RuntimeException("Can't edit first machineSets. The list is empty.");
    return setNewMachineSetLike(0, buildMachineSet(0));
  }
  public MachinePoolStatusFluent.MachineSetsNested<A> editLastMachineSet() {
    int index = machineSets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last machineSets. The list is empty.");
    return setNewMachineSetLike(index, buildMachineSet(index));
  }
  public MachinePoolStatusFluent.MachineSetsNested<A> editMatchingMachineSet(Predicate<MachineSetStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<machineSets.size();i++) { 
    if (predicate.test(machineSets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching machineSets. No match found.");
    return setNewMachineSetLike(index, buildMachineSet(index));
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MachinePoolStatusFluentImpl that = (MachinePoolStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (machineSets != null ? !machineSets.equals(that.machineSets) :that.machineSets != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  machineSets,  replicas,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (machineSets != null && !machineSets.isEmpty()) { sb.append("machineSets:"); sb.append(machineSets + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends MachinePoolConditionFluentImpl<MachinePoolStatusFluent.ConditionsNested<N>> implements MachinePoolStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,MachinePoolCondition item) {
      this.index = index;
      this.builder = new MachinePoolConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new MachinePoolConditionBuilder(this);
    }
    MachinePoolConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) MachinePoolStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class MachineSetsNestedImpl<N> extends MachineSetStatusFluentImpl<MachinePoolStatusFluent.MachineSetsNested<N>> implements MachinePoolStatusFluent.MachineSetsNested<N>,Nested<N>{
    MachineSetsNestedImpl(Integer index,MachineSetStatus item) {
      this.index = index;
      this.builder = new MachineSetStatusBuilder(this, item);
    }
    MachineSetsNestedImpl() {
      this.index = -1;
      this.builder = new MachineSetStatusBuilder(this);
    }
    MachineSetStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) MachinePoolStatusFluentImpl.this.setToMachineSets(index,builder.build());
    }
    public N endMachineSet() {
      return and();
    }
    
  }
  
}