package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachinePoolNameLeaseListFluentImpl<A extends MachinePoolNameLeaseListFluent<A>> extends BaseFluent<A> implements MachinePoolNameLeaseListFluent<A>{
  public MachinePoolNameLeaseListFluentImpl() {
  }
  public MachinePoolNameLeaseListFluentImpl(MachinePoolNameLeaseList instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private ArrayList<MachinePoolNameLeaseBuilder> items = new ArrayList<MachinePoolNameLeaseBuilder>();
  private String kind;
  private ListMeta metadata;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(Integer index,MachinePoolNameLease item) {
    if (this.items == null) {this.items = new ArrayList<MachinePoolNameLeaseBuilder>();}
    MachinePoolNameLeaseBuilder builder = new MachinePoolNameLeaseBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToItems(Integer index,MachinePoolNameLease item) {
    if (this.items == null) {this.items = new ArrayList<MachinePoolNameLeaseBuilder>();}
    MachinePoolNameLeaseBuilder builder = new MachinePoolNameLeaseBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToItems(io.fabric8.openshift.api.model.hive.v1.MachinePoolNameLease... items) {
    if (this.items == null) {this.items = new ArrayList<MachinePoolNameLeaseBuilder>();}
    for (MachinePoolNameLease item : items) {MachinePoolNameLeaseBuilder builder = new MachinePoolNameLeaseBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(Collection<MachinePoolNameLease> items) {
    if (this.items == null) {this.items = new ArrayList<MachinePoolNameLeaseBuilder>();}
    for (MachinePoolNameLease item : items) {MachinePoolNameLeaseBuilder builder = new MachinePoolNameLeaseBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.openshift.api.model.hive.v1.MachinePoolNameLease... items) {
    for (MachinePoolNameLease item : items) {MachinePoolNameLeaseBuilder builder = new MachinePoolNameLeaseBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(Collection<MachinePoolNameLease> items) {
    for (MachinePoolNameLease item : items) {MachinePoolNameLeaseBuilder builder = new MachinePoolNameLeaseBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(Predicate<MachinePoolNameLeaseBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<MachinePoolNameLeaseBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      MachinePoolNameLeaseBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MachinePoolNameLease> getItems() {
    return items != null ? build(items) : null;
  }
  public List<MachinePoolNameLease> buildItems() {
    return items != null ? build(items) : null;
  }
  public MachinePoolNameLease buildItem(Integer index) {
    return this.items.get(index).build();
  }
  public MachinePoolNameLease buildFirstItem() {
    return this.items.get(0).build();
  }
  public MachinePoolNameLease buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public MachinePoolNameLease buildMatchingItem(Predicate<MachinePoolNameLeaseBuilder> predicate) {
    for (MachinePoolNameLeaseBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingItem(Predicate<MachinePoolNameLeaseBuilder> predicate) {
    for (MachinePoolNameLeaseBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<MachinePoolNameLease> items) {
    if (this.items != null) { _visitables.get("items").removeAll(this.items);}
    if (items != null) {this.items = new ArrayList(); for (MachinePoolNameLease item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.openshift.api.model.hive.v1.MachinePoolNameLease... items) {
    if (this.items != null) {this.items.clear();}
    if (items != null) {for (MachinePoolNameLease item :items){ this.addToItems(item);}} return (A) this;
  }
  public Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public MachinePoolNameLeaseListFluent.ItemsNested<A> addNewItem() {
    return new MachinePoolNameLeaseListFluentImpl.ItemsNestedImpl();
  }
  public MachinePoolNameLeaseListFluent.ItemsNested<A> addNewItemLike(MachinePoolNameLease item) {
    return new MachinePoolNameLeaseListFluentImpl.ItemsNestedImpl(-1, item);
  }
  public MachinePoolNameLeaseListFluent.ItemsNested<A> setNewItemLike(Integer index,MachinePoolNameLease item) {
    return new MachinePoolNameLeaseListFluentImpl.ItemsNestedImpl(index, item);
  }
  public MachinePoolNameLeaseListFluent.ItemsNested<A> editItem(Integer index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public MachinePoolNameLeaseListFluent.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public MachinePoolNameLeaseListFluent.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public MachinePoolNameLeaseListFluent.ItemsNested<A> editMatchingItem(Predicate<MachinePoolNameLeaseBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public ListMeta getMetadata() {
    return this.metadata;
  }
  public A withMetadata(ListMeta metadata) {
    this.metadata=metadata; return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MachinePoolNameLeaseListFluentImpl that = (MachinePoolNameLeaseListFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (items != null ? !items.equals(that.items) :that.items != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ItemsNestedImpl<N> extends MachinePoolNameLeaseFluentImpl<MachinePoolNameLeaseListFluent.ItemsNested<N>> implements MachinePoolNameLeaseListFluent.ItemsNested<N>,Nested<N>{
    ItemsNestedImpl(Integer index,MachinePoolNameLease item) {
      this.index = index;
      this.builder = new MachinePoolNameLeaseBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new MachinePoolNameLeaseBuilder(this);
    }
    MachinePoolNameLeaseBuilder builder;
    Integer index;
    public N and() {
      return (N) MachinePoolNameLeaseListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  
}