package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolNameLeaseListBuilder extends MachinePoolNameLeaseListFluentImpl<MachinePoolNameLeaseListBuilder> implements VisitableBuilder<MachinePoolNameLeaseList,MachinePoolNameLeaseListBuilder>{
  public MachinePoolNameLeaseListBuilder() {
    this(false);
  }
  public MachinePoolNameLeaseListBuilder(Boolean validationEnabled) {
    this(new MachinePoolNameLeaseList(), validationEnabled);
  }
  public MachinePoolNameLeaseListBuilder(MachinePoolNameLeaseListFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolNameLeaseListBuilder(MachinePoolNameLeaseListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePoolNameLeaseList(), validationEnabled);
  }
  public MachinePoolNameLeaseListBuilder(MachinePoolNameLeaseListFluent<?> fluent,MachinePoolNameLeaseList instance) {
    this(fluent, instance, false);
  }
  public MachinePoolNameLeaseListBuilder(MachinePoolNameLeaseListFluent<?> fluent,MachinePoolNameLeaseList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolNameLeaseListBuilder(MachinePoolNameLeaseList instance) {
    this(instance,false);
  }
  public MachinePoolNameLeaseListBuilder(MachinePoolNameLeaseList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MachinePoolNameLeaseListFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePoolNameLeaseList build() {
    MachinePoolNameLeaseList buildable = new MachinePoolNameLeaseList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}