package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ClusterStateListFluent<A extends ClusterStateListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,ClusterState item);
  public A setToItems(Integer index,ClusterState item);
  public A addToItems(io.fabric8.openshift.api.model.hive.v1.ClusterState... items);
  public A addAllToItems(Collection<ClusterState> items);
  public A removeFromItems(io.fabric8.openshift.api.model.hive.v1.ClusterState... items);
  public A removeAllFromItems(Collection<ClusterState> items);
  public A removeMatchingFromItems(Predicate<ClusterStateBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterState> getItems();
  public List<ClusterState> buildItems();
  public ClusterState buildItem(Integer index);
  public ClusterState buildFirstItem();
  public ClusterState buildLastItem();
  public ClusterState buildMatchingItem(Predicate<ClusterStateBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ClusterStateBuilder> predicate);
  public A withItems(List<ClusterState> items);
  public A withItems(io.fabric8.openshift.api.model.hive.v1.ClusterState... items);
  public Boolean hasItems();
  public ClusterStateListFluent.ItemsNested<A> addNewItem();
  public ClusterStateListFluent.ItemsNested<A> addNewItemLike(ClusterState item);
  public ClusterStateListFluent.ItemsNested<A> setNewItemLike(Integer index,ClusterState item);
  public ClusterStateListFluent.ItemsNested<A> editItem(Integer index);
  public ClusterStateListFluent.ItemsNested<A> editFirstItem();
  public ClusterStateListFluent.ItemsNested<A> editLastItem();
  public ClusterStateListFluent.ItemsNested<A> editMatchingItem(Predicate<ClusterStateBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,ClusterStateFluent<ClusterStateListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}