package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterStateBuilder extends ClusterStateFluentImpl<ClusterStateBuilder> implements VisitableBuilder<ClusterState,ClusterStateBuilder>{
  public ClusterStateBuilder() {
    this(false);
  }
  public ClusterStateBuilder(Boolean validationEnabled) {
    this(new ClusterState(), validationEnabled);
  }
  public ClusterStateBuilder(ClusterStateFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterStateBuilder(ClusterStateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterState(), validationEnabled);
  }
  public ClusterStateBuilder(ClusterStateFluent<?> fluent,ClusterState instance) {
    this(fluent, instance, false);
  }
  public ClusterStateBuilder(ClusterStateFluent<?> fluent,ClusterState instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterStateBuilder(ClusterState instance) {
    this(instance,false);
  }
  public ClusterStateBuilder(ClusterState instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterStateFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterState build() {
    ClusterState buildable = new ClusterState(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}