package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterProvisionStatusFluentImpl<A extends ClusterProvisionStatusFluent<A>> extends BaseFluent<A> implements ClusterProvisionStatusFluent<A>{
  public ClusterProvisionStatusFluentImpl() {
  }
  public ClusterProvisionStatusFluentImpl(ClusterProvisionStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withJobRef(instance.getJobRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ClusterProvisionConditionBuilder> conditions = new ArrayList<ClusterProvisionConditionBuilder>();
  private LocalObjectReferenceBuilder jobRef;
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,ClusterProvisionCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterProvisionConditionBuilder>();}
    ClusterProvisionConditionBuilder builder = new ClusterProvisionConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,ClusterProvisionCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterProvisionConditionBuilder>();}
    ClusterProvisionConditionBuilder builder = new ClusterProvisionConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.hive.v1.ClusterProvisionCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterProvisionConditionBuilder>();}
    for (ClusterProvisionCondition item : items) {ClusterProvisionConditionBuilder builder = new ClusterProvisionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ClusterProvisionCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterProvisionConditionBuilder>();}
    for (ClusterProvisionCondition item : items) {ClusterProvisionConditionBuilder builder = new ClusterProvisionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.hive.v1.ClusterProvisionCondition... items) {
    for (ClusterProvisionCondition item : items) {ClusterProvisionConditionBuilder builder = new ClusterProvisionConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ClusterProvisionCondition> items) {
    for (ClusterProvisionCondition item : items) {ClusterProvisionConditionBuilder builder = new ClusterProvisionConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ClusterProvisionConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ClusterProvisionConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ClusterProvisionConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterProvisionCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ClusterProvisionCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ClusterProvisionCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public ClusterProvisionCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ClusterProvisionCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ClusterProvisionCondition buildMatchingCondition(Predicate<ClusterProvisionConditionBuilder> predicate) {
    for (ClusterProvisionConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ClusterProvisionConditionBuilder> predicate) {
    for (ClusterProvisionConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ClusterProvisionCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (ClusterProvisionCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.hive.v1.ClusterProvisionCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (ClusterProvisionCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ClusterProvisionStatusFluent.ConditionsNested<A> addNewCondition() {
    return new ClusterProvisionStatusFluentImpl.ConditionsNestedImpl();
  }
  public ClusterProvisionStatusFluent.ConditionsNested<A> addNewConditionLike(ClusterProvisionCondition item) {
    return new ClusterProvisionStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ClusterProvisionStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,ClusterProvisionCondition item) {
    return new ClusterProvisionStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ClusterProvisionStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterProvisionStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ClusterProvisionStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterProvisionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ClusterProvisionConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildJobRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getJobRef() {
    return this.jobRef!=null ?this.jobRef.build():null;
  }
  public LocalObjectReference buildJobRef() {
    return this.jobRef!=null ?this.jobRef.build():null;
  }
  public A withJobRef(LocalObjectReference jobRef) {
    _visitables.get("jobRef").remove(this.jobRef);
    if (jobRef!=null){ this.jobRef= new LocalObjectReferenceBuilder(jobRef); _visitables.get("jobRef").add(this.jobRef);} else { this.jobRef = null; _visitables.get("jobRef").remove(this.jobRef); } return (A) this;
  }
  public Boolean hasJobRef() {
    return this.jobRef != null;
  }
  public A withNewJobRef(String name) {
    return (A)withJobRef(new LocalObjectReference(name));
  }
  public ClusterProvisionStatusFluent.JobRefNested<A> withNewJobRef() {
    return new ClusterProvisionStatusFluentImpl.JobRefNestedImpl();
  }
  public ClusterProvisionStatusFluent.JobRefNested<A> withNewJobRefLike(LocalObjectReference item) {
    return new ClusterProvisionStatusFluentImpl.JobRefNestedImpl(item);
  }
  public ClusterProvisionStatusFluent.JobRefNested<A> editJobRef() {
    return withNewJobRefLike(getJobRef());
  }
  public ClusterProvisionStatusFluent.JobRefNested<A> editOrNewJobRef() {
    return withNewJobRefLike(getJobRef() != null ? getJobRef(): new LocalObjectReferenceBuilder().build());
  }
  public ClusterProvisionStatusFluent.JobRefNested<A> editOrNewJobRefLike(LocalObjectReference item) {
    return withNewJobRefLike(getJobRef() != null ? getJobRef(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterProvisionStatusFluentImpl that = (ClusterProvisionStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (jobRef != null ? !jobRef.equals(that.jobRef) :that.jobRef != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  jobRef,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (jobRef != null) { sb.append("jobRef:"); sb.append(jobRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ClusterProvisionConditionFluentImpl<ClusterProvisionStatusFluent.ConditionsNested<N>> implements ClusterProvisionStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,ClusterProvisionCondition item) {
      this.index = index;
      this.builder = new ClusterProvisionConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ClusterProvisionConditionBuilder(this);
    }
    ClusterProvisionConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) ClusterProvisionStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class JobRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ClusterProvisionStatusFluent.JobRefNested<N>> implements ClusterProvisionStatusFluent.JobRefNested<N>,Nested<N>{
    JobRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    JobRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterProvisionStatusFluentImpl.this.withJobRef(builder.build());
    }
    public N endJobRef() {
      return and();
    }
    
  }
  
}