package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterPoolConditionBuilder extends ClusterPoolConditionFluentImpl<ClusterPoolConditionBuilder> implements VisitableBuilder<ClusterPoolCondition,ClusterPoolConditionBuilder>{
  public ClusterPoolConditionBuilder() {
    this(false);
  }
  public ClusterPoolConditionBuilder(Boolean validationEnabled) {
    this(new ClusterPoolCondition(), validationEnabled);
  }
  public ClusterPoolConditionBuilder(ClusterPoolConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterPoolConditionBuilder(ClusterPoolConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterPoolCondition(), validationEnabled);
  }
  public ClusterPoolConditionBuilder(ClusterPoolConditionFluent<?> fluent,ClusterPoolCondition instance) {
    this(fluent, instance, false);
  }
  public ClusterPoolConditionBuilder(ClusterPoolConditionFluent<?> fluent,ClusterPoolCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastProbeTime(instance.getLastProbeTime()); 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterPoolConditionBuilder(ClusterPoolCondition instance) {
    this(instance,false);
  }
  public ClusterPoolConditionBuilder(ClusterPoolCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastProbeTime(instance.getLastProbeTime()); 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterPoolConditionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterPoolCondition build() {
    ClusterPoolCondition buildable = new ClusterPoolCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}