package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ClusterIngressFluent<A extends ClusterIngressFluent<A>> extends Fluent<A>{
  public String getDomain();
  public A withDomain(String domain);
  public Boolean hasDomain();
  public String getName();
  public A withName(String name);
  public Boolean hasName();
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getNamespaceSelector();
  public LabelSelector buildNamespaceSelector();
  public A withNamespaceSelector(LabelSelector namespaceSelector);
  public Boolean hasNamespaceSelector();
  public ClusterIngressFluent.NamespaceSelectorNested<A> withNewNamespaceSelector();
  public ClusterIngressFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item);
  public ClusterIngressFluent.NamespaceSelectorNested<A> editNamespaceSelector();
  public ClusterIngressFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector();
  public ClusterIngressFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item);
  
  /**
   * This method has been deprecated, please use method buildRouteSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getRouteSelector();
  public LabelSelector buildRouteSelector();
  public A withRouteSelector(LabelSelector routeSelector);
  public Boolean hasRouteSelector();
  public ClusterIngressFluent.RouteSelectorNested<A> withNewRouteSelector();
  public ClusterIngressFluent.RouteSelectorNested<A> withNewRouteSelectorLike(LabelSelector item);
  public ClusterIngressFluent.RouteSelectorNested<A> editRouteSelector();
  public ClusterIngressFluent.RouteSelectorNested<A> editOrNewRouteSelector();
  public ClusterIngressFluent.RouteSelectorNested<A> editOrNewRouteSelectorLike(LabelSelector item);
  public String getServingCertificate();
  public A withServingCertificate(String servingCertificate);
  public Boolean hasServingCertificate();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface NamespaceSelectorNested<N> extends Nested<N>,LabelSelectorFluent<ClusterIngressFluent.NamespaceSelectorNested<N>>{
    public N and();
    public N endNamespaceSelector();
    
  }
  public interface RouteSelectorNested<N> extends Nested<N>,LabelSelectorFluent<ClusterIngressFluent.RouteSelectorNested<N>>{
    public N and();
    public N endRouteSelector();
    
  }
  
}