package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterImageSetStatusBuilder extends ClusterImageSetStatusFluentImpl<ClusterImageSetStatusBuilder> implements VisitableBuilder<ClusterImageSetStatus,ClusterImageSetStatusBuilder>{
  public ClusterImageSetStatusBuilder() {
    this(false);
  }
  public ClusterImageSetStatusBuilder(Boolean validationEnabled) {
    this(new ClusterImageSetStatus(), validationEnabled);
  }
  public ClusterImageSetStatusBuilder(ClusterImageSetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterImageSetStatusBuilder(ClusterImageSetStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterImageSetStatus(), validationEnabled);
  }
  public ClusterImageSetStatusBuilder(ClusterImageSetStatusFluent<?> fluent,ClusterImageSetStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterImageSetStatusBuilder(ClusterImageSetStatusFluent<?> fluent,ClusterImageSetStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterImageSetStatusBuilder(ClusterImageSetStatus instance) {
    this(instance,false);
  }
  public ClusterImageSetStatusBuilder(ClusterImageSetStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterImageSetStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterImageSetStatus build() {
    ClusterImageSetStatus buildable = new ClusterImageSetStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}