package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface ClusterDeploymentStatusFluent<A extends ClusterDeploymentStatusFluent<A>> extends Fluent<A>{
  public String getApiURL();
  public A withApiURL(String apiURL);
  public Boolean hasApiURL();
  public A addToCertificateBundles(Integer index,CertificateBundleStatus item);
  public A setToCertificateBundles(Integer index,CertificateBundleStatus item);
  public A addToCertificateBundles(io.fabric8.openshift.api.model.hive.v1.CertificateBundleStatus... items);
  public A addAllToCertificateBundles(Collection<CertificateBundleStatus> items);
  public A removeFromCertificateBundles(io.fabric8.openshift.api.model.hive.v1.CertificateBundleStatus... items);
  public A removeAllFromCertificateBundles(Collection<CertificateBundleStatus> items);
  public A removeMatchingFromCertificateBundles(Predicate<CertificateBundleStatusBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildCertificateBundles instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CertificateBundleStatus> getCertificateBundles();
  public List<CertificateBundleStatus> buildCertificateBundles();
  public CertificateBundleStatus buildCertificateBundle(Integer index);
  public CertificateBundleStatus buildFirstCertificateBundle();
  public CertificateBundleStatus buildLastCertificateBundle();
  public CertificateBundleStatus buildMatchingCertificateBundle(Predicate<CertificateBundleStatusBuilder> predicate);
  public Boolean hasMatchingCertificateBundle(Predicate<CertificateBundleStatusBuilder> predicate);
  public A withCertificateBundles(List<CertificateBundleStatus> certificateBundles);
  public A withCertificateBundles(io.fabric8.openshift.api.model.hive.v1.CertificateBundleStatus... certificateBundles);
  public Boolean hasCertificateBundles();
  public A addNewCertificateBundle(Boolean generated,String name);
  public ClusterDeploymentStatusFluent.CertificateBundlesNested<A> addNewCertificateBundle();
  public ClusterDeploymentStatusFluent.CertificateBundlesNested<A> addNewCertificateBundleLike(CertificateBundleStatus item);
  public ClusterDeploymentStatusFluent.CertificateBundlesNested<A> setNewCertificateBundleLike(Integer index,CertificateBundleStatus item);
  public ClusterDeploymentStatusFluent.CertificateBundlesNested<A> editCertificateBundle(Integer index);
  public ClusterDeploymentStatusFluent.CertificateBundlesNested<A> editFirstCertificateBundle();
  public ClusterDeploymentStatusFluent.CertificateBundlesNested<A> editLastCertificateBundle();
  public ClusterDeploymentStatusFluent.CertificateBundlesNested<A> editMatchingCertificateBundle(Predicate<CertificateBundleStatusBuilder> predicate);
  public String getCliImage();
  public A withCliImage(String cliImage);
  public Boolean hasCliImage();
  public A addToConditions(Integer index,ClusterDeploymentCondition item);
  public A setToConditions(Integer index,ClusterDeploymentCondition item);
  public A addToConditions(io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentCondition... items);
  public A addAllToConditions(Collection<ClusterDeploymentCondition> items);
  public A removeFromConditions(io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentCondition... items);
  public A removeAllFromConditions(Collection<ClusterDeploymentCondition> items);
  public A removeMatchingFromConditions(Predicate<ClusterDeploymentConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterDeploymentCondition> getConditions();
  public List<ClusterDeploymentCondition> buildConditions();
  public ClusterDeploymentCondition buildCondition(Integer index);
  public ClusterDeploymentCondition buildFirstCondition();
  public ClusterDeploymentCondition buildLastCondition();
  public ClusterDeploymentCondition buildMatchingCondition(Predicate<ClusterDeploymentConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<ClusterDeploymentConditionBuilder> predicate);
  public A withConditions(List<ClusterDeploymentCondition> conditions);
  public A withConditions(io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentCondition... conditions);
  public Boolean hasConditions();
  public ClusterDeploymentStatusFluent.ConditionsNested<A> addNewCondition();
  public ClusterDeploymentStatusFluent.ConditionsNested<A> addNewConditionLike(ClusterDeploymentCondition item);
  public ClusterDeploymentStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,ClusterDeploymentCondition item);
  public ClusterDeploymentStatusFluent.ConditionsNested<A> editCondition(Integer index);
  public ClusterDeploymentStatusFluent.ConditionsNested<A> editFirstCondition();
  public ClusterDeploymentStatusFluent.ConditionsNested<A> editLastCondition();
  public ClusterDeploymentStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ClusterDeploymentConditionBuilder> predicate);
  public Integer getInstallRestarts();
  public A withInstallRestarts(Integer installRestarts);
  public Boolean hasInstallRestarts();
  public String getInstallStartedTimestamp();
  public A withInstallStartedTimestamp(String installStartedTimestamp);
  public Boolean hasInstallStartedTimestamp();
  public String getInstallVersion();
  public A withInstallVersion(String installVersion);
  public Boolean hasInstallVersion();
  public String getInstalledTimestamp();
  public A withInstalledTimestamp(String installedTimestamp);
  public Boolean hasInstalledTimestamp();
  public String getInstallerImage();
  public A withInstallerImage(String installerImage);
  public Boolean hasInstallerImage();
  
  /**
   * This method has been deprecated, please use method buildPlatformStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public PlatformStatus getPlatformStatus();
  public PlatformStatus buildPlatformStatus();
  public A withPlatformStatus(PlatformStatus platformStatus);
  public Boolean hasPlatformStatus();
  public ClusterDeploymentStatusFluent.PlatformStatusNested<A> withNewPlatformStatus();
  public ClusterDeploymentStatusFluent.PlatformStatusNested<A> withNewPlatformStatusLike(PlatformStatus item);
  public ClusterDeploymentStatusFluent.PlatformStatusNested<A> editPlatformStatus();
  public ClusterDeploymentStatusFluent.PlatformStatusNested<A> editOrNewPlatformStatus();
  public ClusterDeploymentStatusFluent.PlatformStatusNested<A> editOrNewPlatformStatusLike(PlatformStatus item);
  public String getPowerState();
  public A withPowerState(String powerState);
  public Boolean hasPowerState();
  
  /**
   * This method has been deprecated, please use method buildProvisionRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getProvisionRef();
  public LocalObjectReference buildProvisionRef();
  public A withProvisionRef(LocalObjectReference provisionRef);
  public Boolean hasProvisionRef();
  public A withNewProvisionRef(String name);
  public ClusterDeploymentStatusFluent.ProvisionRefNested<A> withNewProvisionRef();
  public ClusterDeploymentStatusFluent.ProvisionRefNested<A> withNewProvisionRefLike(LocalObjectReference item);
  public ClusterDeploymentStatusFluent.ProvisionRefNested<A> editProvisionRef();
  public ClusterDeploymentStatusFluent.ProvisionRefNested<A> editOrNewProvisionRef();
  public ClusterDeploymentStatusFluent.ProvisionRefNested<A> editOrNewProvisionRefLike(LocalObjectReference item);
  public String getWebConsoleURL();
  public A withWebConsoleURL(String webConsoleURL);
  public Boolean hasWebConsoleURL();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface CertificateBundlesNested<N> extends Nested<N>,CertificateBundleStatusFluent<ClusterDeploymentStatusFluent.CertificateBundlesNested<N>>{
    public N and();
    public N endCertificateBundle();
    
  }
  public interface ConditionsNested<N> extends Nested<N>,ClusterDeploymentConditionFluent<ClusterDeploymentStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface PlatformStatusNested<N> extends Nested<N>,PlatformStatusFluent<ClusterDeploymentStatusFluent.PlatformStatusNested<N>>{
    public N and();
    public N endPlatformStatus();
    
  }
  public interface ProvisionRefNested<N> extends Nested<N>,LocalObjectReferenceFluent<ClusterDeploymentStatusFluent.ProvisionRefNested<N>>{
    public N and();
    public N endProvisionRef();
    
  }
  
}