package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterDeploymentFluentImpl<A extends ClusterDeploymentFluent<A>> extends BaseFluent<A> implements ClusterDeploymentFluent<A>{
  public ClusterDeploymentFluentImpl() {
  }
  public ClusterDeploymentFluentImpl(ClusterDeployment instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ClusterDeploymentSpecBuilder spec;
  private ClusterDeploymentStatusBuilder status;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ClusterDeploymentFluent.MetadataNested<A> withNewMetadata() {
    return new ClusterDeploymentFluentImpl.MetadataNestedImpl();
  }
  public ClusterDeploymentFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ClusterDeploymentFluentImpl.MetadataNestedImpl(item);
  }
  public ClusterDeploymentFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ClusterDeploymentFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ClusterDeploymentFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterDeploymentSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ClusterDeploymentSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ClusterDeploymentSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ClusterDeploymentSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ClusterDeploymentFluent.SpecNested<A> withNewSpec() {
    return new ClusterDeploymentFluentImpl.SpecNestedImpl();
  }
  public ClusterDeploymentFluent.SpecNested<A> withNewSpecLike(ClusterDeploymentSpec item) {
    return new ClusterDeploymentFluentImpl.SpecNestedImpl(item);
  }
  public ClusterDeploymentFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ClusterDeploymentFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ClusterDeploymentSpecBuilder().build());
  }
  public ClusterDeploymentFluent.SpecNested<A> editOrNewSpecLike(ClusterDeploymentSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterDeploymentStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public ClusterDeploymentStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(ClusterDeploymentStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new ClusterDeploymentStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public ClusterDeploymentFluent.StatusNested<A> withNewStatus() {
    return new ClusterDeploymentFluentImpl.StatusNestedImpl();
  }
  public ClusterDeploymentFluent.StatusNested<A> withNewStatusLike(ClusterDeploymentStatus item) {
    return new ClusterDeploymentFluentImpl.StatusNestedImpl(item);
  }
  public ClusterDeploymentFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public ClusterDeploymentFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new ClusterDeploymentStatusBuilder().build());
  }
  public ClusterDeploymentFluent.StatusNested<A> editOrNewStatusLike(ClusterDeploymentStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterDeploymentFluentImpl that = (ClusterDeploymentFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ClusterDeploymentFluent.MetadataNested<N>> implements ClusterDeploymentFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ClusterDeploymentFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ClusterDeploymentSpecFluentImpl<ClusterDeploymentFluent.SpecNested<N>> implements ClusterDeploymentFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ClusterDeploymentSpec item) {
      this.builder = new ClusterDeploymentSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ClusterDeploymentSpecBuilder(this);
    }
    ClusterDeploymentSpecBuilder builder;
    public N and() {
      return (N) ClusterDeploymentFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends ClusterDeploymentStatusFluentImpl<ClusterDeploymentFluent.StatusNested<N>> implements ClusterDeploymentFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(ClusterDeploymentStatus item) {
      this.builder = new ClusterDeploymentStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new ClusterDeploymentStatusBuilder(this);
    }
    ClusterDeploymentStatusBuilder builder;
    public N and() {
      return (N) ClusterDeploymentFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}