package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AzureDNSZoneSpecFluentImpl<A extends AzureDNSZoneSpecFluent<A>> extends BaseFluent<A> implements AzureDNSZoneSpecFluent<A>{
  public AzureDNSZoneSpecFluentImpl() {
  }
  public AzureDNSZoneSpecFluentImpl(AzureDNSZoneSpec instance) {
    this.withCloudName(instance.getCloudName()); 
    this.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    this.withResourceGroupName(instance.getResourceGroupName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String cloudName;
  private LocalObjectReferenceBuilder credentialsSecretRef;
  private String resourceGroupName;
  private Map<String,Object> additionalProperties;
  public String getCloudName() {
    return this.cloudName;
  }
  public A withCloudName(String cloudName) {
    this.cloudName=cloudName; return (A) this;
  }
  public Boolean hasCloudName() {
    return this.cloudName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCredentialsSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public LocalObjectReference buildCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
    _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef);
    if (credentialsSecretRef!=null){ this.credentialsSecretRef= new LocalObjectReferenceBuilder(credentialsSecretRef); _visitables.get("credentialsSecretRef").add(this.credentialsSecretRef);} else { this.credentialsSecretRef = null; _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef); } return (A) this;
  }
  public Boolean hasCredentialsSecretRef() {
    return this.credentialsSecretRef != null;
  }
  public A withNewCredentialsSecretRef(String name) {
    return (A)withCredentialsSecretRef(new LocalObjectReference(name));
  }
  public AzureDNSZoneSpecFluent.CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
    return new AzureDNSZoneSpecFluentImpl.CredentialsSecretRefNestedImpl();
  }
  public AzureDNSZoneSpecFluent.CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
    return new AzureDNSZoneSpecFluentImpl.CredentialsSecretRefNestedImpl(item);
  }
  public AzureDNSZoneSpecFluent.CredentialsSecretRefNested<A> editCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef());
  }
  public AzureDNSZoneSpecFluent.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public AzureDNSZoneSpecFluent.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): item);
  }
  public String getResourceGroupName() {
    return this.resourceGroupName;
  }
  public A withResourceGroupName(String resourceGroupName) {
    this.resourceGroupName=resourceGroupName; return (A) this;
  }
  public Boolean hasResourceGroupName() {
    return this.resourceGroupName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AzureDNSZoneSpecFluentImpl that = (AzureDNSZoneSpecFluentImpl) o;
    if (cloudName != null ? !cloudName.equals(that.cloudName) :that.cloudName != null) return false;
    if (credentialsSecretRef != null ? !credentialsSecretRef.equals(that.credentialsSecretRef) :that.credentialsSecretRef != null) return false;
    if (resourceGroupName != null ? !resourceGroupName.equals(that.resourceGroupName) :that.resourceGroupName != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(cloudName,  credentialsSecretRef,  resourceGroupName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cloudName != null) { sb.append("cloudName:"); sb.append(cloudName + ","); }
    if (credentialsSecretRef != null) { sb.append("credentialsSecretRef:"); sb.append(credentialsSecretRef + ","); }
    if (resourceGroupName != null) { sb.append("resourceGroupName:"); sb.append(resourceGroupName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CredentialsSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<AzureDNSZoneSpecFluent.CredentialsSecretRefNested<N>> implements AzureDNSZoneSpecFluent.CredentialsSecretRefNested<N>,Nested<N>{
    CredentialsSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    CredentialsSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) AzureDNSZoneSpecFluentImpl.this.withCredentialsSecretRef(builder.build());
    }
    public N endCredentialsSecretRef() {
      return and();
    }
    
  }
  
}