package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSDNSZoneStatusBuilder extends AWSDNSZoneStatusFluentImpl<AWSDNSZoneStatusBuilder> implements VisitableBuilder<AWSDNSZoneStatus,AWSDNSZoneStatusBuilder>{
  public AWSDNSZoneStatusBuilder() {
    this(false);
  }
  public AWSDNSZoneStatusBuilder(Boolean validationEnabled) {
    this(new AWSDNSZoneStatus(), validationEnabled);
  }
  public AWSDNSZoneStatusBuilder(AWSDNSZoneStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSDNSZoneStatusBuilder(AWSDNSZoneStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSDNSZoneStatus(), validationEnabled);
  }
  public AWSDNSZoneStatusBuilder(AWSDNSZoneStatusFluent<?> fluent,AWSDNSZoneStatus instance) {
    this(fluent, instance, false);
  }
  public AWSDNSZoneStatusBuilder(AWSDNSZoneStatusFluent<?> fluent,AWSDNSZoneStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withZoneID(instance.getZoneID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AWSDNSZoneStatusBuilder(AWSDNSZoneStatus instance) {
    this(instance,false);
  }
  public AWSDNSZoneStatusBuilder(AWSDNSZoneStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withZoneID(instance.getZoneID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AWSDNSZoneStatusFluent<?> fluent;
  Boolean validationEnabled;
  public AWSDNSZoneStatus build() {
    AWSDNSZoneStatus buildable = new AWSDNSZoneStatus(fluent.getZoneID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}