package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AssumeRoleBuilder extends AssumeRoleFluentImpl<AssumeRoleBuilder> implements VisitableBuilder<AssumeRole,AssumeRoleBuilder>{
  public AssumeRoleBuilder() {
    this(false);
  }
  public AssumeRoleBuilder(Boolean validationEnabled) {
    this(new AssumeRole(), validationEnabled);
  }
  public AssumeRoleBuilder(AssumeRoleFluent<?> fluent) {
    this(fluent, false);
  }
  public AssumeRoleBuilder(AssumeRoleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AssumeRole(), validationEnabled);
  }
  public AssumeRoleBuilder(AssumeRoleFluent<?> fluent,AssumeRole instance) {
    this(fluent, instance, false);
  }
  public AssumeRoleBuilder(AssumeRoleFluent<?> fluent,AssumeRole instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExternalID(instance.getExternalID()); 
    fluent.withRoleARN(instance.getRoleARN()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AssumeRoleBuilder(AssumeRole instance) {
    this(instance,false);
  }
  public AssumeRoleBuilder(AssumeRole instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExternalID(instance.getExternalID()); 
    this.withRoleARN(instance.getRoleARN()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AssumeRoleFluent<?> fluent;
  Boolean validationEnabled;
  public AssumeRole build() {
    AssumeRole buildable = new AssumeRole(fluent.getExternalID(),fluent.getRoleARN());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}