package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProvisioningBuilder extends ProvisioningFluent<ProvisioningBuilder> implements VisitableBuilder<Provisioning,ProvisioningBuilder>{
  public ProvisioningBuilder() {
    this(new Provisioning());
  }
  
  public ProvisioningBuilder(ProvisioningFluent<?> fluent) {
    this(fluent, new Provisioning());
  }
  
  public ProvisioningBuilder(ProvisioningFluent<?> fluent,Provisioning instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProvisioningBuilder(Provisioning instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProvisioningFluent<?> fluent;
  
  public Provisioning build() {
    Provisioning buildable = new Provisioning(fluent.buildImageSetRef(),fluent.buildInstallConfigSecretRef(),fluent.getInstallerEnv(),fluent.getInstallerImageOverride(),fluent.buildManifestsConfigMapRef(),fluent.buildManifestsSecretRef(),fluent.getReleaseImage(),fluent.getSshKnownHosts(),fluent.buildSshPrivateKeySecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}