package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class FailedProvisionConfigFluent<A extends FailedProvisionConfigFluent<A>> extends BaseFluent<A>{
  public FailedProvisionConfigFluent() {
  }
  
  public FailedProvisionConfigFluent(FailedProvisionConfig instance) {
    this.copyInstance(instance);
  }
  private FailedProvisionAWSConfigBuilder aws;
  private List<String> retryReasons = new ArrayList<String>();
  private Boolean skipGatherLogs;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(FailedProvisionConfig instance) {
    instance = (instance != null ? instance : new FailedProvisionConfig());
    if (instance != null) {
          this.withAws(instance.getAws());
          this.withRetryReasons(instance.getRetryReasons());
          this.withSkipGatherLogs(instance.getSkipGatherLogs());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public FailedProvisionAWSConfig buildAws() {
    return this.aws != null ? this.aws.build() : null;
  }
  
  public A withAws(FailedProvisionAWSConfig aws) {
    this._visitables.remove("aws");
    if (aws != null) {
        this.aws = new FailedProvisionAWSConfigBuilder(aws);
        this._visitables.get("aws").add(this.aws);
    } else {
        this.aws = null;
        this._visitables.get("aws").remove(this.aws);
    }
    return (A) this;
  }
  
  public boolean hasAws() {
    return this.aws != null;
  }
  
  public AwsNested<A> withNewAws() {
    return new AwsNested(null);
  }
  
  public AwsNested<A> withNewAwsLike(FailedProvisionAWSConfig item) {
    return new AwsNested(item);
  }
  
  public AwsNested<A> editAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(null));
  }
  
  public AwsNested<A> editOrNewAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(new FailedProvisionAWSConfigBuilder().build()));
  }
  
  public AwsNested<A> editOrNewAwsLike(FailedProvisionAWSConfig item) {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(item));
  }
  
  public A addToRetryReasons(int index,String item) {
    if (this.retryReasons == null) {this.retryReasons = new ArrayList<String>();}
    this.retryReasons.add(index, item);
    return (A)this;
  }
  
  public A setToRetryReasons(int index,String item) {
    if (this.retryReasons == null) {this.retryReasons = new ArrayList<String>();}
    this.retryReasons.set(index, item); return (A)this;
  }
  
  public A addToRetryReasons(java.lang.String... items) {
    if (this.retryReasons == null) {this.retryReasons = new ArrayList<String>();}
    for (String item : items) {this.retryReasons.add(item);} return (A)this;
  }
  
  public A addAllToRetryReasons(Collection<String> items) {
    if (this.retryReasons == null) {this.retryReasons = new ArrayList<String>();}
    for (String item : items) {this.retryReasons.add(item);} return (A)this;
  }
  
  public A removeFromRetryReasons(java.lang.String... items) {
    if (this.retryReasons == null) return (A)this;
    for (String item : items) { this.retryReasons.remove(item);} return (A)this;
  }
  
  public A removeAllFromRetryReasons(Collection<String> items) {
    if (this.retryReasons == null) return (A)this;
    for (String item : items) { this.retryReasons.remove(item);} return (A)this;
  }
  
  public List<String> getRetryReasons() {
    return this.retryReasons;
  }
  
  public String getRetryReason(int index) {
    return this.retryReasons.get(index);
  }
  
  public String getFirstRetryReason() {
    return this.retryReasons.get(0);
  }
  
  public String getLastRetryReason() {
    return this.retryReasons.get(retryReasons.size() - 1);
  }
  
  public String getMatchingRetryReason(Predicate<String> predicate) {
      for (String item : retryReasons) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingRetryReason(Predicate<String> predicate) {
      for (String item : retryReasons) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRetryReasons(List<String> retryReasons) {
    if (retryReasons != null) {
        this.retryReasons = new ArrayList();
        for (String item : retryReasons) {
          this.addToRetryReasons(item);
        }
    } else {
      this.retryReasons = null;
    }
    return (A) this;
  }
  
  public A withRetryReasons(java.lang.String... retryReasons) {
    if (this.retryReasons != null) {
        this.retryReasons.clear();
        _visitables.remove("retryReasons");
    }
    if (retryReasons != null) {
      for (String item : retryReasons) {
        this.addToRetryReasons(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRetryReasons() {
    return this.retryReasons != null && !this.retryReasons.isEmpty();
  }
  
  public Boolean getSkipGatherLogs() {
    return this.skipGatherLogs;
  }
  
  public A withSkipGatherLogs(Boolean skipGatherLogs) {
    this.skipGatherLogs = skipGatherLogs;
    return (A) this;
  }
  
  public boolean hasSkipGatherLogs() {
    return this.skipGatherLogs != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    FailedProvisionConfigFluent that = (FailedProvisionConfigFluent) o;
    if (!java.util.Objects.equals(aws, that.aws)) return false;
    if (!java.util.Objects.equals(retryReasons, that.retryReasons)) return false;
    if (!java.util.Objects.equals(skipGatherLogs, that.skipGatherLogs)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(aws,  retryReasons,  skipGatherLogs,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (retryReasons != null && !retryReasons.isEmpty()) { sb.append("retryReasons:"); sb.append(retryReasons + ","); }
    if (skipGatherLogs != null) { sb.append("skipGatherLogs:"); sb.append(skipGatherLogs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSkipGatherLogs() {
    return withSkipGatherLogs(true);
  }
  public class AwsNested<N> extends FailedProvisionAWSConfigFluent<AwsNested<N>> implements Nested<N>{
    AwsNested(FailedProvisionAWSConfig item) {
      this.builder = new FailedProvisionAWSConfigBuilder(this, item);
    }
    FailedProvisionAWSConfigBuilder builder;
    
    public N and() {
      return (N) FailedProvisionConfigFluent.this.withAws(builder.build());
    }
    
    public N endAws() {
      return and();
    }
    
  
  }

}