package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ArgoCDConfigBuilder extends ArgoCDConfigFluent<ArgoCDConfigBuilder> implements VisitableBuilder<ArgoCDConfig,ArgoCDConfigBuilder>{
  public ArgoCDConfigBuilder() {
    this(new ArgoCDConfig());
  }
  
  public ArgoCDConfigBuilder(ArgoCDConfigFluent<?> fluent) {
    this(fluent, new ArgoCDConfig());
  }
  
  public ArgoCDConfigBuilder(ArgoCDConfigFluent<?> fluent,ArgoCDConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ArgoCDConfigBuilder(ArgoCDConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ArgoCDConfigFluent<?> fluent;
  
  public ArgoCDConfig build() {
    ArgoCDConfig buildable = new ArgoCDConfig(fluent.getEnabled(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}