package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AwsPlatformBuilder extends AwsPlatformFluent<AwsPlatformBuilder> implements VisitableBuilder<AwsPlatform,AwsPlatformBuilder>{
  public AwsPlatformBuilder() {
    this(new AwsPlatform());
  }
  
  public AwsPlatformBuilder(AwsPlatformFluent<?> fluent) {
    this(fluent, new AwsPlatform());
  }
  
  public AwsPlatformBuilder(AwsPlatformFluent<?> fluent,AwsPlatform instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AwsPlatformBuilder(AwsPlatform instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AwsPlatformFluent<?> fluent;
  
  public AwsPlatform build() {
    AwsPlatform buildable = new AwsPlatform(fluent.buildCredentialsAssumeRole(),fluent.buildCredentialsSecretRef(),fluent.buildPrivateLink(),fluent.getRegion(),fluent.getUserTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}