package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleYAMLSampleSpecBuilder extends ConsoleYAMLSampleSpecFluentImpl<ConsoleYAMLSampleSpecBuilder> implements VisitableBuilder<ConsoleYAMLSampleSpec,ConsoleYAMLSampleSpecBuilder>{
  public ConsoleYAMLSampleSpecBuilder() {
    this(false);
  }
  public ConsoleYAMLSampleSpecBuilder(Boolean validationEnabled) {
    this(new ConsoleYAMLSampleSpec(), validationEnabled);
  }
  public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleYAMLSampleSpec(), validationEnabled);
  }
  public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpecFluent<?> fluent,ConsoleYAMLSampleSpec instance) {
    this(fluent, instance, false);
  }
  public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpecFluent<?> fluent,ConsoleYAMLSampleSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withSnippet(instance.getSnippet());
      fluent.withTargetResource(instance.getTargetResource());
      fluent.withTitle(instance.getTitle());
      fluent.withYaml(instance.getYaml());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpec instance) {
    this(instance,false);
  }
  public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withSnippet(instance.getSnippet());
      this.withTargetResource(instance.getTargetResource());
      this.withTitle(instance.getTitle());
      this.withYaml(instance.getYaml());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleYAMLSampleSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleYAMLSampleSpec build() {
    ConsoleYAMLSampleSpec buildable = new ConsoleYAMLSampleSpec(fluent.getDescription(),fluent.getSnippet(),fluent.getTargetResource(),fluent.getTitle(),fluent.getYaml());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}