package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleYAMLSampleBuilder extends ConsoleYAMLSampleFluentImpl<ConsoleYAMLSampleBuilder> implements VisitableBuilder<ConsoleYAMLSample,ConsoleYAMLSampleBuilder>{
  public ConsoleYAMLSampleBuilder() {
    this(false);
  }
  public ConsoleYAMLSampleBuilder(Boolean validationEnabled) {
    this(new ConsoleYAMLSample(), validationEnabled);
  }
  public ConsoleYAMLSampleBuilder(ConsoleYAMLSampleFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleYAMLSampleBuilder(ConsoleYAMLSampleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleYAMLSample(), validationEnabled);
  }
  public ConsoleYAMLSampleBuilder(ConsoleYAMLSampleFluent<?> fluent,ConsoleYAMLSample instance) {
    this(fluent, instance, false);
  }
  public ConsoleYAMLSampleBuilder(ConsoleYAMLSampleFluent<?> fluent,ConsoleYAMLSample instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleYAMLSampleBuilder(ConsoleYAMLSample instance) {
    this(instance,false);
  }
  public ConsoleYAMLSampleBuilder(ConsoleYAMLSample instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleYAMLSampleFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleYAMLSample build() {
    ConsoleYAMLSample buildable = new ConsoleYAMLSample(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}