package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleQuickStartTaskBuilder extends ConsoleQuickStartTaskFluentImpl<ConsoleQuickStartTaskBuilder> implements VisitableBuilder<ConsoleQuickStartTask,ConsoleQuickStartTaskBuilder>{
  public ConsoleQuickStartTaskBuilder() {
    this(false);
  }
  public ConsoleQuickStartTaskBuilder(Boolean validationEnabled) {
    this(new ConsoleQuickStartTask(), validationEnabled);
  }
  public ConsoleQuickStartTaskBuilder(ConsoleQuickStartTaskFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleQuickStartTaskBuilder(ConsoleQuickStartTaskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleQuickStartTask(), validationEnabled);
  }
  public ConsoleQuickStartTaskBuilder(ConsoleQuickStartTaskFluent<?> fluent,ConsoleQuickStartTask instance) {
    this(fluent, instance, false);
  }
  public ConsoleQuickStartTaskBuilder(ConsoleQuickStartTaskFluent<?> fluent,ConsoleQuickStartTask instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withReview(instance.getReview());
      fluent.withSummary(instance.getSummary());
      fluent.withTitle(instance.getTitle());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleQuickStartTaskBuilder(ConsoleQuickStartTask instance) {
    this(instance,false);
  }
  public ConsoleQuickStartTaskBuilder(ConsoleQuickStartTask instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withReview(instance.getReview());
      this.withSummary(instance.getSummary());
      this.withTitle(instance.getTitle());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleQuickStartTaskFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleQuickStartTask build() {
    ConsoleQuickStartTask buildable = new ConsoleQuickStartTask(fluent.getDescription(),fluent.getReview(),fluent.getSummary(),fluent.getTitle());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}