package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleQuickStartBuilder extends ConsoleQuickStartFluentImpl<ConsoleQuickStartBuilder> implements VisitableBuilder<ConsoleQuickStart,ConsoleQuickStartBuilder>{
  public ConsoleQuickStartBuilder() {
    this(false);
  }
  public ConsoleQuickStartBuilder(Boolean validationEnabled) {
    this(new ConsoleQuickStart(), validationEnabled);
  }
  public ConsoleQuickStartBuilder(ConsoleQuickStartFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleQuickStartBuilder(ConsoleQuickStartFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleQuickStart(), validationEnabled);
  }
  public ConsoleQuickStartBuilder(ConsoleQuickStartFluent<?> fluent,ConsoleQuickStart instance) {
    this(fluent, instance, false);
  }
  public ConsoleQuickStartBuilder(ConsoleQuickStartFluent<?> fluent,ConsoleQuickStart instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleQuickStartBuilder(ConsoleQuickStart instance) {
    this(instance,false);
  }
  public ConsoleQuickStartBuilder(ConsoleQuickStart instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleQuickStartFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleQuickStart build() {
    ConsoleQuickStart buildable = new ConsoleQuickStart(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}