package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleExternalLogLinkListBuilder extends ConsoleExternalLogLinkListFluentImpl<ConsoleExternalLogLinkListBuilder> implements VisitableBuilder<ConsoleExternalLogLinkList,ConsoleExternalLogLinkListBuilder>{
  public ConsoleExternalLogLinkListBuilder() {
    this(false);
  }
  public ConsoleExternalLogLinkListBuilder(Boolean validationEnabled) {
    this(new ConsoleExternalLogLinkList(), validationEnabled);
  }
  public ConsoleExternalLogLinkListBuilder(ConsoleExternalLogLinkListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleExternalLogLinkListBuilder(ConsoleExternalLogLinkListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleExternalLogLinkList(), validationEnabled);
  }
  public ConsoleExternalLogLinkListBuilder(ConsoleExternalLogLinkListFluent<?> fluent,ConsoleExternalLogLinkList instance) {
    this(fluent, instance, false);
  }
  public ConsoleExternalLogLinkListBuilder(ConsoleExternalLogLinkListFluent<?> fluent,ConsoleExternalLogLinkList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleExternalLogLinkListBuilder(ConsoleExternalLogLinkList instance) {
    this(instance,false);
  }
  public ConsoleExternalLogLinkListBuilder(ConsoleExternalLogLinkList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleExternalLogLinkListFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleExternalLogLinkList build() {
    ConsoleExternalLogLinkList buildable = new ConsoleExternalLogLinkList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}