package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamespaceDashboardSpecBuilder extends NamespaceDashboardSpecFluentImpl<NamespaceDashboardSpecBuilder> implements VisitableBuilder<NamespaceDashboardSpec,NamespaceDashboardSpecBuilder>{
  public NamespaceDashboardSpecBuilder() {
    this(false);
  }
  public NamespaceDashboardSpecBuilder(Boolean validationEnabled) {
    this(new NamespaceDashboardSpec(), validationEnabled);
  }
  public NamespaceDashboardSpecBuilder(NamespaceDashboardSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NamespaceDashboardSpecBuilder(NamespaceDashboardSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NamespaceDashboardSpec(), validationEnabled);
  }
  public NamespaceDashboardSpecBuilder(NamespaceDashboardSpecFluent<?> fluent,NamespaceDashboardSpec instance) {
    this(fluent, instance, false);
  }
  public NamespaceDashboardSpecBuilder(NamespaceDashboardSpecFluent<?> fluent,NamespaceDashboardSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
    fluent.withNamespaces(instance.getNamespaces()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NamespaceDashboardSpecBuilder(NamespaceDashboardSpec instance) {
    this(instance,false);
  }
  public NamespaceDashboardSpecBuilder(NamespaceDashboardSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withNamespaces(instance.getNamespaces()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  NamespaceDashboardSpecFluent<?> fluent;
  Boolean validationEnabled;
  public NamespaceDashboardSpec build() {
    NamespaceDashboardSpec buildable = new NamespaceDashboardSpec(fluent.getNamespaceSelector(),fluent.getNamespaces());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}