package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CLIDownloadLinkBuilder extends CLIDownloadLinkFluentImpl<CLIDownloadLinkBuilder> implements VisitableBuilder<CLIDownloadLink,CLIDownloadLinkBuilder>{
  public CLIDownloadLinkBuilder() {
    this(false);
  }
  public CLIDownloadLinkBuilder(Boolean validationEnabled) {
    this(new CLIDownloadLink(), validationEnabled);
  }
  public CLIDownloadLinkBuilder(CLIDownloadLinkFluent<?> fluent) {
    this(fluent, false);
  }
  public CLIDownloadLinkBuilder(CLIDownloadLinkFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CLIDownloadLink(), validationEnabled);
  }
  public CLIDownloadLinkBuilder(CLIDownloadLinkFluent<?> fluent,CLIDownloadLink instance) {
    this(fluent, instance, false);
  }
  public CLIDownloadLinkBuilder(CLIDownloadLinkFluent<?> fluent,CLIDownloadLink instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHref(instance.getHref()); 
    fluent.withText(instance.getText()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CLIDownloadLinkBuilder(CLIDownloadLink instance) {
    this(instance,false);
  }
  public CLIDownloadLinkBuilder(CLIDownloadLink instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withHref(instance.getHref()); 
    this.withText(instance.getText()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CLIDownloadLinkFluent<?> fluent;
  Boolean validationEnabled;
  public CLIDownloadLink build() {
    CLIDownloadLink buildable = new CLIDownloadLink(fluent.getHref(),fluent.getText());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}