/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.openshift.api.model.config.v1.ImageDigestMirrorSet;
import io.fabric8.openshift.api.model.config.v1.ImageDigestMirrorSetBuilder;
import io.fabric8.openshift.api.model.config.v1.ImageDigestMirrorSetFluent;
import io.fabric8.openshift.api.model.config.v1.ImageDigestMirrorSetList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageDigestMirrorSetListFluent<A extends ImageDigestMirrorSetListFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private ArrayList<ImageDigestMirrorSetBuilder> items = new ArrayList();
    private String kind;
    private ListMeta metadata;

    public ImageDigestMirrorSetListFluent() {
    }

    public ImageDigestMirrorSetListFluent(ImageDigestMirrorSetList instance) {
        this.copyInstance(instance);
    }

    public A addAllToItems(Collection<ImageDigestMirrorSet> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ImageDigestMirrorSet item : items) {
            ImageDigestMirrorSetBuilder builder = new ImageDigestMirrorSetBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(ImageDigestMirrorSet item) {
        return new ItemsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToItems(ImageDigestMirrorSet ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ImageDigestMirrorSet item : items) {
            ImageDigestMirrorSetBuilder builder = new ImageDigestMirrorSetBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToItems(int index, ImageDigestMirrorSet item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ImageDigestMirrorSetBuilder builder = new ImageDigestMirrorSetBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ImageDigestMirrorSet buildFirstItem() {
        return this.items.get(0).build();
    }

    public ImageDigestMirrorSet buildItem(int index) {
        return this.items.get(index).build();
    }

    public List<ImageDigestMirrorSet> buildItems() {
        return this.items != null ? ImageDigestMirrorSetListFluent.build(this.items) : null;
    }

    public ImageDigestMirrorSet buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public ImageDigestMirrorSet buildMatchingItem(Predicate<ImageDigestMirrorSetBuilder> predicate) {
        for (ImageDigestMirrorSetBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(ImageDigestMirrorSetList instance) {
        ImageDigestMirrorSetList imageDigestMirrorSetList = instance = instance != null ? instance : new ImageDigestMirrorSetList();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "items"));
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "items"));
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "items"));
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<ImageDigestMirrorSetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "items"));
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageDigestMirrorSetListFluent that = (ImageDigestMirrorSetListFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public ListMeta getMetadata() {
        return this.metadata;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMatchingItem(Predicate<ImageDigestMirrorSetBuilder> predicate) {
        for (ImageDigestMirrorSetBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, this.additionalProperties);
    }

    public A removeAllFromItems(Collection<ImageDigestMirrorSet> items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (ImageDigestMirrorSet item : items) {
            ImageDigestMirrorSetBuilder builder = new ImageDigestMirrorSetBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromItems(ImageDigestMirrorSet ... items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (ImageDigestMirrorSet item : items) {
            ImageDigestMirrorSetBuilder builder = new ImageDigestMirrorSetBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromItems(Predicate<ImageDigestMirrorSetBuilder> predicate) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        Iterator<ImageDigestMirrorSetBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ImageDigestMirrorSetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ItemsNested<A> setNewItemLike(int index, ImageDigestMirrorSet item) {
        return new ItemsNested(index, item);
    }

    public A setToItems(int index, ImageDigestMirrorSet item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ImageDigestMirrorSetBuilder builder = new ImageDigestMirrorSetBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(builder);
            this.items.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withItems(List<ImageDigestMirrorSet> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (ImageDigestMirrorSet item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)((Object)this);
    }

    public A withItems(ImageDigestMirrorSet ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove((Object)"items");
        }
        if (items != null) {
            for (ImageDigestMirrorSet item : items) {
                this.addToItems(item);
            }
        }
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)((Object)this);
    }

    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public class ItemsNested<N>
    extends ImageDigestMirrorSetFluent<ItemsNested<N>>
    implements Nested<N> {
        ImageDigestMirrorSetBuilder builder;
        int index;

        ItemsNested(int index, ImageDigestMirrorSet item) {
            this.index = index;
            this.builder = new ImageDigestMirrorSetBuilder(this, item);
        }

        public N and() {
            return (N)ImageDigestMirrorSetListFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

