/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceFluent;
import io.fabric8.openshift.api.model.config.v1.ProfileCustomizations;
import io.fabric8.openshift.api.model.config.v1.ProfileCustomizationsBuilder;
import io.fabric8.openshift.api.model.config.v1.ProfileCustomizationsFluent;
import io.fabric8.openshift.api.model.config.v1.SchedulerSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SchedulerSpecFluent<A extends SchedulerSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String defaultNodeSelector;
    private Boolean mastersSchedulable;
    private ConfigMapNameReferenceBuilder policy;
    private String profile;
    private ProfileCustomizationsBuilder profileCustomizations;

    public SchedulerSpecFluent() {
    }

    public SchedulerSpecFluent(SchedulerSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ConfigMapNameReference buildPolicy() {
        return this.policy != null ? this.policy.build() : null;
    }

    public ProfileCustomizations buildProfileCustomizations() {
        return this.profileCustomizations != null ? this.profileCustomizations.build() : null;
    }

    protected void copyInstance(SchedulerSpec instance) {
        SchedulerSpec schedulerSpec = instance = instance != null ? instance : new SchedulerSpec();
        if (instance != null) {
            this.withDefaultNodeSelector(instance.getDefaultNodeSelector());
            this.withMastersSchedulable(instance.getMastersSchedulable());
            this.withPolicy(instance.getPolicy());
            this.withProfile(instance.getProfile());
            this.withProfileCustomizations(instance.getProfileCustomizations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PolicyNested<A> editOrNewPolicy() {
        return this.withNewPolicyLike(Optional.ofNullable(this.buildPolicy()).orElse(new ConfigMapNameReferenceBuilder().build()));
    }

    public PolicyNested<A> editOrNewPolicyLike(ConfigMapNameReference item) {
        return this.withNewPolicyLike(Optional.ofNullable(this.buildPolicy()).orElse(item));
    }

    public ProfileCustomizationsNested<A> editOrNewProfileCustomizations() {
        return this.withNewProfileCustomizationsLike(Optional.ofNullable(this.buildProfileCustomizations()).orElse(new ProfileCustomizationsBuilder().build()));
    }

    public ProfileCustomizationsNested<A> editOrNewProfileCustomizationsLike(ProfileCustomizations item) {
        return this.withNewProfileCustomizationsLike(Optional.ofNullable(this.buildProfileCustomizations()).orElse(item));
    }

    public PolicyNested<A> editPolicy() {
        return this.withNewPolicyLike(Optional.ofNullable(this.buildPolicy()).orElse(null));
    }

    public ProfileCustomizationsNested<A> editProfileCustomizations() {
        return this.withNewProfileCustomizationsLike(Optional.ofNullable(this.buildProfileCustomizations()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchedulerSpecFluent that = (SchedulerSpecFluent)((Object)o);
        if (!Objects.equals(this.defaultNodeSelector, that.defaultNodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.mastersSchedulable, that.mastersSchedulable)) {
            return false;
        }
        if (!Objects.equals((Object)this.policy, (Object)that.policy)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        if (!Objects.equals((Object)this.profileCustomizations, (Object)that.profileCustomizations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getDefaultNodeSelector() {
        return this.defaultNodeSelector;
    }

    public Boolean getMastersSchedulable() {
        return this.mastersSchedulable;
    }

    public String getProfile() {
        return this.profile;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDefaultNodeSelector() {
        return this.defaultNodeSelector != null;
    }

    public boolean hasMastersSchedulable() {
        return this.mastersSchedulable != null;
    }

    public boolean hasPolicy() {
        return this.policy != null;
    }

    public boolean hasProfile() {
        return this.profile != null;
    }

    public boolean hasProfileCustomizations() {
        return this.profileCustomizations != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultNodeSelector, this.mastersSchedulable, this.policy, this.profile, this.profileCustomizations, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultNodeSelector != null) {
            sb.append("defaultNodeSelector:");
            sb.append(this.defaultNodeSelector);
            sb.append(",");
        }
        if (this.mastersSchedulable != null) {
            sb.append("mastersSchedulable:");
            sb.append(this.mastersSchedulable);
            sb.append(",");
        }
        if (this.policy != null) {
            sb.append("policy:");
            sb.append((Object)this.policy);
            sb.append(",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile);
            sb.append(",");
        }
        if (this.profileCustomizations != null) {
            sb.append("profileCustomizations:");
            sb.append((Object)this.profileCustomizations);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDefaultNodeSelector(String defaultNodeSelector) {
        this.defaultNodeSelector = defaultNodeSelector;
        return (A)((Object)this);
    }

    public A withMastersSchedulable() {
        return this.withMastersSchedulable(true);
    }

    public A withMastersSchedulable(Boolean mastersSchedulable) {
        this.mastersSchedulable = mastersSchedulable;
        return (A)((Object)this);
    }

    public PolicyNested<A> withNewPolicy() {
        return new PolicyNested(null);
    }

    public A withNewPolicy(String name) {
        return this.withPolicy(new ConfigMapNameReference(name));
    }

    public PolicyNested<A> withNewPolicyLike(ConfigMapNameReference item) {
        return new PolicyNested(item);
    }

    public ProfileCustomizationsNested<A> withNewProfileCustomizations() {
        return new ProfileCustomizationsNested(null);
    }

    public A withNewProfileCustomizations(String dynamicResourceAllocation) {
        return this.withProfileCustomizations(new ProfileCustomizations(dynamicResourceAllocation));
    }

    public ProfileCustomizationsNested<A> withNewProfileCustomizationsLike(ProfileCustomizations item) {
        return new ProfileCustomizationsNested(item);
    }

    public A withPolicy(ConfigMapNameReference policy) {
        this._visitables.remove((Object)"policy");
        if (policy != null) {
            this.policy = new ConfigMapNameReferenceBuilder(policy);
            this._visitables.get((Object)"policy").add(this.policy);
        } else {
            this.policy = null;
            this._visitables.get((Object)"policy").remove((Object)this.policy);
        }
        return (A)((Object)this);
    }

    public A withProfile(String profile) {
        this.profile = profile;
        return (A)((Object)this);
    }

    public A withProfileCustomizations(ProfileCustomizations profileCustomizations) {
        this._visitables.remove((Object)"profileCustomizations");
        if (profileCustomizations != null) {
            this.profileCustomizations = new ProfileCustomizationsBuilder(profileCustomizations);
            this._visitables.get((Object)"profileCustomizations").add(this.profileCustomizations);
        } else {
            this.profileCustomizations = null;
            this._visitables.get((Object)"profileCustomizations").remove((Object)this.profileCustomizations);
        }
        return (A)((Object)this);
    }

    public class ProfileCustomizationsNested<N>
    extends ProfileCustomizationsFluent<ProfileCustomizationsNested<N>>
    implements Nested<N> {
        ProfileCustomizationsBuilder builder;

        ProfileCustomizationsNested(ProfileCustomizations item) {
            this.builder = new ProfileCustomizationsBuilder(this, item);
        }

        public N and() {
            return (N)SchedulerSpecFluent.this.withProfileCustomizations(this.builder.build());
        }

        public N endProfileCustomizations() {
            return this.and();
        }
    }

    public class PolicyNested<N>
    extends ConfigMapNameReferenceFluent<PolicyNested<N>>
    implements Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        PolicyNested(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        public N and() {
            return (N)SchedulerSpecFluent.this.withPolicy(this.builder.build());
        }

        public N endPolicy() {
            return this.and();
        }
    }
}

