/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.HTTPServingInfo;
import io.fabric8.openshift.api.model.config.v1.NamedCertificate;
import io.fabric8.openshift.api.model.config.v1.NamedCertificateBuilder;
import io.fabric8.openshift.api.model.config.v1.NamedCertificateFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPServingInfoFluent<A extends HTTPServingInfoFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String bindAddress;
    private String bindNetwork;
    private String certFile;
    private List<String> cipherSuites = new ArrayList<String>();
    private String clientCA;
    private String keyFile;
    private Long maxRequestsInFlight;
    private String minTLSVersion;
    private ArrayList<NamedCertificateBuilder> namedCertificates = new ArrayList();
    private Long requestTimeoutSeconds;

    public HTTPServingInfoFluent() {
    }

    public HTTPServingInfoFluent(HTTPServingInfo instance) {
        this.copyInstance(instance);
    }

    public A addAllToCipherSuites(Collection<String> items) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        for (String item : items) {
            this.cipherSuites.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToNamedCertificates(Collection<NamedCertificate> items) {
        if (this.namedCertificates == null) {
            this.namedCertificates = new ArrayList();
        }
        for (NamedCertificate item : items) {
            NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
            this._visitables.get((Object)"namedCertificates").add(builder);
            this.namedCertificates.add(builder);
        }
        return (A)((Object)this);
    }

    public NamedCertificatesNested<A> addNewNamedCertificate() {
        return new NamedCertificatesNested(-1, null);
    }

    public NamedCertificatesNested<A> addNewNamedCertificateLike(NamedCertificate item) {
        return new NamedCertificatesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToCipherSuites(String ... items) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        for (String item : items) {
            this.cipherSuites.add(item);
        }
        return (A)((Object)this);
    }

    public A addToCipherSuites(int index, String item) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        this.cipherSuites.add(index, item);
        return (A)((Object)this);
    }

    public A addToNamedCertificates(NamedCertificate ... items) {
        if (this.namedCertificates == null) {
            this.namedCertificates = new ArrayList();
        }
        for (NamedCertificate item : items) {
            NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
            this._visitables.get((Object)"namedCertificates").add(builder);
            this.namedCertificates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToNamedCertificates(int index, NamedCertificate item) {
        if (this.namedCertificates == null) {
            this.namedCertificates = new ArrayList();
        }
        NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
        if (index < 0 || index >= this.namedCertificates.size()) {
            this._visitables.get((Object)"namedCertificates").add(builder);
            this.namedCertificates.add(builder);
        } else {
            this._visitables.get((Object)"namedCertificates").add(builder);
            this.namedCertificates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public NamedCertificate buildFirstNamedCertificate() {
        return this.namedCertificates.get(0).build();
    }

    public NamedCertificate buildLastNamedCertificate() {
        return this.namedCertificates.get(this.namedCertificates.size() - 1).build();
    }

    public NamedCertificate buildMatchingNamedCertificate(Predicate<NamedCertificateBuilder> predicate) {
        for (NamedCertificateBuilder item : this.namedCertificates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public NamedCertificate buildNamedCertificate(int index) {
        return this.namedCertificates.get(index).build();
    }

    public List<NamedCertificate> buildNamedCertificates() {
        return this.namedCertificates != null ? HTTPServingInfoFluent.build(this.namedCertificates) : null;
    }

    protected void copyInstance(HTTPServingInfo instance) {
        HTTPServingInfo hTTPServingInfo = instance = instance != null ? instance : new HTTPServingInfo();
        if (instance != null) {
            this.withBindAddress(instance.getBindAddress());
            this.withBindNetwork(instance.getBindNetwork());
            this.withCertFile(instance.getCertFile());
            this.withCipherSuites(instance.getCipherSuites());
            this.withClientCA(instance.getClientCA());
            this.withKeyFile(instance.getKeyFile());
            this.withMaxRequestsInFlight(instance.getMaxRequestsInFlight());
            this.withMinTLSVersion(instance.getMinTLSVersion());
            this.withNamedCertificates(instance.getNamedCertificates());
            this.withRequestTimeoutSeconds(instance.getRequestTimeoutSeconds());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public NamedCertificatesNested<A> editFirstNamedCertificate() {
        if (this.namedCertificates.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "namedCertificates"));
        }
        return this.setNewNamedCertificateLike(0, this.buildNamedCertificate(0));
    }

    public NamedCertificatesNested<A> editLastNamedCertificate() {
        int index = this.namedCertificates.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "namedCertificates"));
        }
        return this.setNewNamedCertificateLike(index, this.buildNamedCertificate(index));
    }

    public NamedCertificatesNested<A> editMatchingNamedCertificate(Predicate<NamedCertificateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.namedCertificates.size(); ++i) {
            if (!predicate.test(this.namedCertificates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "namedCertificates"));
        }
        return this.setNewNamedCertificateLike(index, this.buildNamedCertificate(index));
    }

    public NamedCertificatesNested<A> editNamedCertificate(int index) {
        if (this.namedCertificates.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "namedCertificates"));
        }
        return this.setNewNamedCertificateLike(index, this.buildNamedCertificate(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPServingInfoFluent that = (HTTPServingInfoFluent)((Object)o);
        if (!Objects.equals(this.bindAddress, that.bindAddress)) {
            return false;
        }
        if (!Objects.equals(this.bindNetwork, that.bindNetwork)) {
            return false;
        }
        if (!Objects.equals(this.certFile, that.certFile)) {
            return false;
        }
        if (!Objects.equals(this.cipherSuites, that.cipherSuites)) {
            return false;
        }
        if (!Objects.equals(this.clientCA, that.clientCA)) {
            return false;
        }
        if (!Objects.equals(this.keyFile, that.keyFile)) {
            return false;
        }
        if (!Objects.equals(this.maxRequestsInFlight, that.maxRequestsInFlight)) {
            return false;
        }
        if (!Objects.equals(this.minTLSVersion, that.minTLSVersion)) {
            return false;
        }
        if (!Objects.equals(this.namedCertificates, that.namedCertificates)) {
            return false;
        }
        if (!Objects.equals(this.requestTimeoutSeconds, that.requestTimeoutSeconds)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public String getBindNetwork() {
        return this.bindNetwork;
    }

    public String getCertFile() {
        return this.certFile;
    }

    public String getCipherSuite(int index) {
        return this.cipherSuites.get(index);
    }

    public List<String> getCipherSuites() {
        return this.cipherSuites;
    }

    public String getClientCA() {
        return this.clientCA;
    }

    public String getFirstCipherSuite() {
        return this.cipherSuites.get(0);
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public String getLastCipherSuite() {
        return this.cipherSuites.get(this.cipherSuites.size() - 1);
    }

    public String getMatchingCipherSuite(Predicate<String> predicate) {
        for (String item : this.cipherSuites) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Long getMaxRequestsInFlight() {
        return this.maxRequestsInFlight;
    }

    public String getMinTLSVersion() {
        return this.minTLSVersion;
    }

    public Long getRequestTimeoutSeconds() {
        return this.requestTimeoutSeconds;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBindAddress() {
        return this.bindAddress != null;
    }

    public boolean hasBindNetwork() {
        return this.bindNetwork != null;
    }

    public boolean hasCertFile() {
        return this.certFile != null;
    }

    public boolean hasCipherSuites() {
        return this.cipherSuites != null && !this.cipherSuites.isEmpty();
    }

    public boolean hasClientCA() {
        return this.clientCA != null;
    }

    public boolean hasKeyFile() {
        return this.keyFile != null;
    }

    public boolean hasMatchingCipherSuite(Predicate<String> predicate) {
        for (String item : this.cipherSuites) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingNamedCertificate(Predicate<NamedCertificateBuilder> predicate) {
        for (NamedCertificateBuilder item : this.namedCertificates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMaxRequestsInFlight() {
        return this.maxRequestsInFlight != null;
    }

    public boolean hasMinTLSVersion() {
        return this.minTLSVersion != null;
    }

    public boolean hasNamedCertificates() {
        return this.namedCertificates != null && !this.namedCertificates.isEmpty();
    }

    public boolean hasRequestTimeoutSeconds() {
        return this.requestTimeoutSeconds != null;
    }

    public int hashCode() {
        return Objects.hash(this.bindAddress, this.bindNetwork, this.certFile, this.cipherSuites, this.clientCA, this.keyFile, this.maxRequestsInFlight, this.minTLSVersion, this.namedCertificates, this.requestTimeoutSeconds, this.additionalProperties);
    }

    public A removeAllFromCipherSuites(Collection<String> items) {
        if (this.cipherSuites == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.cipherSuites.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNamedCertificates(Collection<NamedCertificate> items) {
        if (this.namedCertificates == null) {
            return (A)((Object)this);
        }
        for (NamedCertificate item : items) {
            NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
            this._visitables.get((Object)"namedCertificates").remove((Object)builder);
            this.namedCertificates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromCipherSuites(String ... items) {
        if (this.cipherSuites == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.cipherSuites.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromNamedCertificates(NamedCertificate ... items) {
        if (this.namedCertificates == null) {
            return (A)((Object)this);
        }
        for (NamedCertificate item : items) {
            NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
            this._visitables.get((Object)"namedCertificates").remove((Object)builder);
            this.namedCertificates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromNamedCertificates(Predicate<NamedCertificateBuilder> predicate) {
        if (this.namedCertificates == null) {
            return (A)((Object)this);
        }
        Iterator<NamedCertificateBuilder> each = this.namedCertificates.iterator();
        List visitables = this._visitables.get((Object)"namedCertificates");
        while (each.hasNext()) {
            NamedCertificateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public NamedCertificatesNested<A> setNewNamedCertificateLike(int index, NamedCertificate item) {
        return new NamedCertificatesNested(index, item);
    }

    public A setToCipherSuites(int index, String item) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        this.cipherSuites.set(index, item);
        return (A)((Object)this);
    }

    public A setToNamedCertificates(int index, NamedCertificate item) {
        if (this.namedCertificates == null) {
            this.namedCertificates = new ArrayList();
        }
        NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
        if (index < 0 || index >= this.namedCertificates.size()) {
            this._visitables.get((Object)"namedCertificates").add(builder);
            this.namedCertificates.add(builder);
        } else {
            this._visitables.get((Object)"namedCertificates").add(builder);
            this.namedCertificates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bindAddress != null) {
            sb.append("bindAddress:");
            sb.append(this.bindAddress);
            sb.append(",");
        }
        if (this.bindNetwork != null) {
            sb.append("bindNetwork:");
            sb.append(this.bindNetwork);
            sb.append(",");
        }
        if (this.certFile != null) {
            sb.append("certFile:");
            sb.append(this.certFile);
            sb.append(",");
        }
        if (this.cipherSuites != null && !this.cipherSuites.isEmpty()) {
            sb.append("cipherSuites:");
            sb.append(this.cipherSuites);
            sb.append(",");
        }
        if (this.clientCA != null) {
            sb.append("clientCA:");
            sb.append(this.clientCA);
            sb.append(",");
        }
        if (this.keyFile != null) {
            sb.append("keyFile:");
            sb.append(this.keyFile);
            sb.append(",");
        }
        if (this.maxRequestsInFlight != null) {
            sb.append("maxRequestsInFlight:");
            sb.append(this.maxRequestsInFlight);
            sb.append(",");
        }
        if (this.minTLSVersion != null) {
            sb.append("minTLSVersion:");
            sb.append(this.minTLSVersion);
            sb.append(",");
        }
        if (this.namedCertificates != null && !this.namedCertificates.isEmpty()) {
            sb.append("namedCertificates:");
            sb.append(this.namedCertificates);
            sb.append(",");
        }
        if (this.requestTimeoutSeconds != null) {
            sb.append("requestTimeoutSeconds:");
            sb.append(this.requestTimeoutSeconds);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
        return (A)((Object)this);
    }

    public A withBindNetwork(String bindNetwork) {
        this.bindNetwork = bindNetwork;
        return (A)((Object)this);
    }

    public A withCertFile(String certFile) {
        this.certFile = certFile;
        return (A)((Object)this);
    }

    public A withCipherSuites(List<String> cipherSuites) {
        if (cipherSuites != null) {
            this.cipherSuites = new ArrayList<String>();
            for (String item : cipherSuites) {
                this.addToCipherSuites(item);
            }
        } else {
            this.cipherSuites = null;
        }
        return (A)((Object)this);
    }

    public A withCipherSuites(String ... cipherSuites) {
        if (this.cipherSuites != null) {
            this.cipherSuites.clear();
            this._visitables.remove((Object)"cipherSuites");
        }
        if (cipherSuites != null) {
            for (String item : cipherSuites) {
                this.addToCipherSuites(item);
            }
        }
        return (A)((Object)this);
    }

    public A withClientCA(String clientCA) {
        this.clientCA = clientCA;
        return (A)((Object)this);
    }

    public A withKeyFile(String keyFile) {
        this.keyFile = keyFile;
        return (A)((Object)this);
    }

    public A withMaxRequestsInFlight(Long maxRequestsInFlight) {
        this.maxRequestsInFlight = maxRequestsInFlight;
        return (A)((Object)this);
    }

    public A withMinTLSVersion(String minTLSVersion) {
        this.minTLSVersion = minTLSVersion;
        return (A)((Object)this);
    }

    public A withNamedCertificates(List<NamedCertificate> namedCertificates) {
        if (this.namedCertificates != null) {
            this._visitables.get((Object)"namedCertificates").clear();
        }
        if (namedCertificates != null) {
            this.namedCertificates = new ArrayList();
            for (NamedCertificate item : namedCertificates) {
                this.addToNamedCertificates(item);
            }
        } else {
            this.namedCertificates = null;
        }
        return (A)((Object)this);
    }

    public A withNamedCertificates(NamedCertificate ... namedCertificates) {
        if (this.namedCertificates != null) {
            this.namedCertificates.clear();
            this._visitables.remove((Object)"namedCertificates");
        }
        if (namedCertificates != null) {
            for (NamedCertificate item : namedCertificates) {
                this.addToNamedCertificates(item);
            }
        }
        return (A)((Object)this);
    }

    public A withRequestTimeoutSeconds(Long requestTimeoutSeconds) {
        this.requestTimeoutSeconds = requestTimeoutSeconds;
        return (A)((Object)this);
    }

    public class NamedCertificatesNested<N>
    extends NamedCertificateFluent<NamedCertificatesNested<N>>
    implements Nested<N> {
        NamedCertificateBuilder builder;
        int index;

        NamedCertificatesNested(int index, NamedCertificate item) {
            this.index = index;
            this.builder = new NamedCertificateBuilder(this, item);
        }

        public N and() {
            return (N)HTTPServingInfoFluent.this.setToNamedCertificates(this.index, this.builder.build());
        }

        public N endNamedCertificate() {
            return this.and();
        }
    }
}

