/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.config.v1.FeatureGateDetails;
import io.fabric8.openshift.api.model.config.v1.FeatureGateDetailsBuilder;
import io.fabric8.openshift.api.model.config.v1.FeatureGateDetailsFluent;
import io.fabric8.openshift.api.model.config.v1.FeatureGateStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class FeatureGateStatusFluent<A extends FeatureGateStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<Condition> conditions = new ArrayList<Condition>();
    private ArrayList<FeatureGateDetailsBuilder> featureGates = new ArrayList();

    public FeatureGateStatusFluent() {
    }

    public FeatureGateStatusFluent(FeatureGateStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToFeatureGates(Collection<FeatureGateDetails> items) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        for (FeatureGateDetails item : items) {
            FeatureGateDetailsBuilder builder = new FeatureGateDetailsBuilder(item);
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        }
        return (A)((Object)this);
    }

    public FeatureGatesNested<A> addNewFeatureGate() {
        return new FeatureGatesNested(-1, null);
    }

    public FeatureGatesNested<A> addNewFeatureGateLike(FeatureGateDetails item) {
        return new FeatureGatesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A addToFeatureGates(FeatureGateDetails ... items) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        for (FeatureGateDetails item : items) {
            FeatureGateDetailsBuilder builder = new FeatureGateDetailsBuilder(item);
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToFeatureGates(int index, FeatureGateDetails item) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        FeatureGateDetailsBuilder builder = new FeatureGateDetailsBuilder(item);
        if (index < 0 || index >= this.featureGates.size()) {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        } else {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public FeatureGateDetails buildFeatureGate(int index) {
        return this.featureGates.get(index).build();
    }

    public List<FeatureGateDetails> buildFeatureGates() {
        return this.featureGates != null ? FeatureGateStatusFluent.build(this.featureGates) : null;
    }

    public FeatureGateDetails buildFirstFeatureGate() {
        return this.featureGates.get(0).build();
    }

    public FeatureGateDetails buildLastFeatureGate() {
        return this.featureGates.get(this.featureGates.size() - 1).build();
    }

    public FeatureGateDetails buildMatchingFeatureGate(Predicate<FeatureGateDetailsBuilder> predicate) {
        for (FeatureGateDetailsBuilder item : this.featureGates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(FeatureGateStatus instance) {
        FeatureGateStatus featureGateStatus = instance = instance != null ? instance : new FeatureGateStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withFeatureGates(instance.getFeatureGates());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FeatureGatesNested<A> editFeatureGate(int index) {
        if (this.featureGates.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "featureGates"));
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public FeatureGatesNested<A> editFirstFeatureGate() {
        if (this.featureGates.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "featureGates"));
        }
        return this.setNewFeatureGateLike(0, this.buildFeatureGate(0));
    }

    public FeatureGatesNested<A> editLastFeatureGate() {
        int index = this.featureGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "featureGates"));
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public FeatureGatesNested<A> editMatchingFeatureGate(Predicate<FeatureGateDetailsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.featureGates.size(); ++i) {
            if (!predicate.test(this.featureGates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "featureGates"));
        }
        return this.setNewFeatureGateLike(index, this.buildFeatureGate(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FeatureGateStatusFluent that = (FeatureGateStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.featureGates, that.featureGates)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasFeatureGates() {
        return this.featureGates != null && !this.featureGates.isEmpty();
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingFeatureGate(Predicate<FeatureGateDetailsBuilder> predicate) {
        for (FeatureGateDetailsBuilder item : this.featureGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.featureGates, this.additionalProperties);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFeatureGates(Collection<FeatureGateDetails> items) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        for (FeatureGateDetails item : items) {
            FeatureGateDetailsBuilder builder = new FeatureGateDetailsBuilder(item);
            this._visitables.get((Object)"featureGates").remove((Object)builder);
            this.featureGates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromFeatureGates(FeatureGateDetails ... items) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        for (FeatureGateDetails item : items) {
            FeatureGateDetailsBuilder builder = new FeatureGateDetailsBuilder(item);
            this._visitables.get((Object)"featureGates").remove((Object)builder);
            this.featureGates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFeatureGates(Predicate<FeatureGateDetailsBuilder> predicate) {
        if (this.featureGates == null) {
            return (A)((Object)this);
        }
        Iterator<FeatureGateDetailsBuilder> each = this.featureGates.iterator();
        List visitables = this._visitables.get((Object)"featureGates");
        while (each.hasNext()) {
            FeatureGateDetailsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public FeatureGatesNested<A> setNewFeatureGateLike(int index, FeatureGateDetails item) {
        return new FeatureGatesNested(index, item);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A setToFeatureGates(int index, FeatureGateDetails item) {
        if (this.featureGates == null) {
            this.featureGates = new ArrayList();
        }
        FeatureGateDetailsBuilder builder = new FeatureGateDetailsBuilder(item);
        if (index < 0 || index >= this.featureGates.size()) {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.add(builder);
        } else {
            this._visitables.get((Object)"featureGates").add(builder);
            this.featureGates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.featureGates != null && !this.featureGates.isEmpty()) {
            sb.append("featureGates:");
            sb.append(this.featureGates);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withFeatureGates(List<FeatureGateDetails> featureGates) {
        if (this.featureGates != null) {
            this._visitables.get((Object)"featureGates").clear();
        }
        if (featureGates != null) {
            this.featureGates = new ArrayList();
            for (FeatureGateDetails item : featureGates) {
                this.addToFeatureGates(item);
            }
        } else {
            this.featureGates = null;
        }
        return (A)((Object)this);
    }

    public A withFeatureGates(FeatureGateDetails ... featureGates) {
        if (this.featureGates != null) {
            this.featureGates.clear();
            this._visitables.remove((Object)"featureGates");
        }
        if (featureGates != null) {
            for (FeatureGateDetails item : featureGates) {
                this.addToFeatureGates(item);
            }
        }
        return (A)((Object)this);
    }

    public class FeatureGatesNested<N>
    extends FeatureGateDetailsFluent<FeatureGatesNested<N>>
    implements Nested<N> {
        FeatureGateDetailsBuilder builder;
        int index;

        FeatureGatesNested(int index, FeatureGateDetails item) {
            this.index = index;
            this.builder = new FeatureGateDetailsBuilder(this, item);
        }

        public N and() {
            return (N)FeatureGateStatusFluent.this.setToFeatureGates(this.index, this.builder.build());
        }

        public N endFeatureGate() {
            return this.and();
        }
    }
}

