/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceFluent;
import io.fabric8.openshift.api.model.config.v1.GitLabIdentityProvider;
import io.fabric8.openshift.api.model.config.v1.SecretNameReference;
import io.fabric8.openshift.api.model.config.v1.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.SecretNameReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GitLabIdentityProviderFluent<A extends GitLabIdentityProviderFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ConfigMapNameReferenceBuilder ca;
    private String clientID;
    private SecretNameReferenceBuilder clientSecret;
    private String url;

    public GitLabIdentityProviderFluent() {
    }

    public GitLabIdentityProviderFluent(GitLabIdentityProvider instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ConfigMapNameReference buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    public SecretNameReference buildClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    protected void copyInstance(GitLabIdentityProvider instance) {
        GitLabIdentityProvider gitLabIdentityProvider = instance = instance != null ? instance : new GitLabIdentityProvider();
        if (instance != null) {
            this.withCa(instance.getCa());
            this.withClientID(instance.getClientID());
            this.withClientSecret(instance.getClientSecret());
            this.withUrl(instance.getUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CaNested<A> editCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(null));
    }

    public ClientSecretNested<A> editClientSecret() {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(null));
    }

    public CaNested<A> editOrNewCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(new ConfigMapNameReferenceBuilder().build()));
    }

    public CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(item));
    }

    public ClientSecretNested<A> editOrNewClientSecret() {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(new SecretNameReferenceBuilder().build()));
    }

    public ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitLabIdentityProviderFluent that = (GitLabIdentityProviderFluent)((Object)o);
        if (!Objects.equals((Object)this.ca, (Object)that.ca)) {
            return false;
        }
        if (!Objects.equals(this.clientID, that.clientID)) {
            return false;
        }
        if (!Objects.equals((Object)this.clientSecret, (Object)that.clientSecret)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCa() {
        return this.ca != null;
    }

    public boolean hasClientID() {
        return this.clientID != null;
    }

    public boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ca, this.clientID, this.clientSecret, this.url, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ca != null) {
            sb.append("ca:");
            sb.append((Object)this.ca);
            sb.append(",");
        }
        if (this.clientID != null) {
            sb.append("clientID:");
            sb.append(this.clientID);
            sb.append(",");
        }
        if (this.clientSecret != null) {
            sb.append("clientSecret:");
            sb.append((Object)this.clientSecret);
            sb.append(",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCa(ConfigMapNameReference ca) {
        this._visitables.remove((Object)"ca");
        if (ca != null) {
            this.ca = new ConfigMapNameReferenceBuilder(ca);
            this._visitables.get((Object)"ca").add(this.ca);
        } else {
            this.ca = null;
            this._visitables.get((Object)"ca").remove((Object)this.ca);
        }
        return (A)((Object)this);
    }

    public A withClientID(String clientID) {
        this.clientID = clientID;
        return (A)((Object)this);
    }

    public A withClientSecret(SecretNameReference clientSecret) {
        this._visitables.remove((Object)"clientSecret");
        if (clientSecret != null) {
            this.clientSecret = new SecretNameReferenceBuilder(clientSecret);
            this._visitables.get((Object)"clientSecret").add(this.clientSecret);
        } else {
            this.clientSecret = null;
            this._visitables.get((Object)"clientSecret").remove((Object)this.clientSecret);
        }
        return (A)((Object)this);
    }

    public CaNested<A> withNewCa() {
        return new CaNested(null);
    }

    public A withNewCa(String name) {
        return this.withCa(new ConfigMapNameReference(name));
    }

    public CaNested<A> withNewCaLike(ConfigMapNameReference item) {
        return new CaNested(item);
    }

    public ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNested(null);
    }

    public A withNewClientSecret(String name) {
        return this.withClientSecret(new SecretNameReference(name));
    }

    public ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
        return new ClientSecretNested(item);
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public class ClientSecretNested<N>
    extends SecretNameReferenceFluent<ClientSecretNested<N>>
    implements Nested<N> {
        SecretNameReferenceBuilder builder;

        ClientSecretNested(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        public N and() {
            return (N)GitLabIdentityProviderFluent.this.withClientSecret(this.builder.build());
        }

        public N endClientSecret() {
            return this.and();
        }
    }

    public class CaNested<N>
    extends ConfigMapNameReferenceFluent<CaNested<N>>
    implements Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        CaNested(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        public N and() {
            return (N)GitLabIdentityProviderFluent.this.withCa(this.builder.build());
        }

        public N endCa() {
            return this.and();
        }
    }
}

