/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatus;
import io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition;
import io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusConditionBuilder;
import io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusConditionFluent;
import io.fabric8.openshift.api.model.config.v1.ObjectReference;
import io.fabric8.openshift.api.model.config.v1.ObjectReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.config.v1.OperandVersion;
import io.fabric8.openshift.api.model.config.v1.OperandVersionBuilder;
import io.fabric8.openshift.api.model.config.v1.OperandVersionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterOperatorStatusFluent<A extends ClusterOperatorStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ClusterOperatorStatusConditionBuilder> conditions = new ArrayList();
    private Object extension;
    private ArrayList<ObjectReferenceBuilder> relatedObjects = new ArrayList();
    private ArrayList<OperandVersionBuilder> versions = new ArrayList();

    public ClusterOperatorStatusFluent() {
    }

    public ClusterOperatorStatusFluent(ClusterOperatorStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ClusterOperatorStatusCondition item : items) {
            ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRelatedObjects(Collection<ObjectReference> items) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVersions(Collection<OperandVersion> items) {
        if (this.versions == null) {
            this.versions = new ArrayList();
        }
        for (OperandVersion item : items) {
            OperandVersionBuilder builder = new OperandVersionBuilder(item);
            this._visitables.get((Object)"versions").add(builder);
            this.versions.add(builder);
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new ClusterOperatorStatusCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item) {
        return new ConditionsNested(-1, item);
    }

    public RelatedObjectsNested<A> addNewRelatedObject() {
        return new RelatedObjectsNested(-1, null);
    }

    public A addNewRelatedObject(String group, String name, String namespace, String resource) {
        return this.addToRelatedObjects(new ObjectReference(group, name, namespace, resource));
    }

    public RelatedObjectsNested<A> addNewRelatedObjectLike(ObjectReference item) {
        return new RelatedObjectsNested(-1, item);
    }

    public VersionsNested<A> addNewVersion() {
        return new VersionsNested(-1, null);
    }

    public A addNewVersion(String name, String version) {
        return this.addToVersions(new OperandVersion(name, version));
    }

    public VersionsNested<A> addNewVersionLike(OperandVersion item) {
        return new VersionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(ClusterOperatorStatusCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ClusterOperatorStatusCondition item : items) {
            ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, ClusterOperatorStatusCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRelatedObjects(ObjectReference ... items) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRelatedObjects(int index, ObjectReference item) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.relatedObjects.size()) {
            this._visitables.get((Object)"relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        } else {
            this._visitables.get((Object)"relatedObjects").add(builder);
            this.relatedObjects.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVersions(OperandVersion ... items) {
        if (this.versions == null) {
            this.versions = new ArrayList();
        }
        for (OperandVersion item : items) {
            OperandVersionBuilder builder = new OperandVersionBuilder(item);
            this._visitables.get((Object)"versions").add(builder);
            this.versions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToVersions(int index, OperandVersion item) {
        if (this.versions == null) {
            this.versions = new ArrayList();
        }
        OperandVersionBuilder builder = new OperandVersionBuilder(item);
        if (index < 0 || index >= this.versions.size()) {
            this._visitables.get((Object)"versions").add(builder);
            this.versions.add(builder);
        } else {
            this._visitables.get((Object)"versions").add(builder);
            this.versions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ClusterOperatorStatusCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<ClusterOperatorStatusCondition> buildConditions() {
        return this.conditions != null ? ClusterOperatorStatusFluent.build(this.conditions) : null;
    }

    public ClusterOperatorStatusCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public ObjectReference buildFirstRelatedObject() {
        return this.relatedObjects.get(0).build();
    }

    public OperandVersion buildFirstVersion() {
        return this.versions.get(0).build();
    }

    public ClusterOperatorStatusCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public ObjectReference buildLastRelatedObject() {
        return this.relatedObjects.get(this.relatedObjects.size() - 1).build();
    }

    public OperandVersion buildLastVersion() {
        return this.versions.get(this.versions.size() - 1).build();
    }

    public ClusterOperatorStatusCondition buildMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        for (ClusterOperatorStatusConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ObjectReference buildMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.relatedObjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public OperandVersion buildMatchingVersion(Predicate<OperandVersionBuilder> predicate) {
        for (OperandVersionBuilder item : this.versions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ObjectReference buildRelatedObject(int index) {
        return this.relatedObjects.get(index).build();
    }

    public List<ObjectReference> buildRelatedObjects() {
        return this.relatedObjects != null ? ClusterOperatorStatusFluent.build(this.relatedObjects) : null;
    }

    public OperandVersion buildVersion(int index) {
        return this.versions.get(index).build();
    }

    public List<OperandVersion> buildVersions() {
        return this.versions != null ? ClusterOperatorStatusFluent.build(this.versions) : null;
    }

    protected void copyInstance(ClusterOperatorStatus instance) {
        ClusterOperatorStatus clusterOperatorStatus = instance = instance != null ? instance : new ClusterOperatorStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withExtension(instance.getExtension());
            this.withRelatedObjects(instance.getRelatedObjects());
            this.withVersions(instance.getVersions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public RelatedObjectsNested<A> editFirstRelatedObject() {
        if (this.relatedObjects.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "relatedObjects"));
        }
        return this.setNewRelatedObjectLike(0, this.buildRelatedObject(0));
    }

    public VersionsNested<A> editFirstVersion() {
        if (this.versions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "versions"));
        }
        return this.setNewVersionLike(0, this.buildVersion(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public RelatedObjectsNested<A> editLastRelatedObject() {
        int index = this.relatedObjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "relatedObjects"));
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    public VersionsNested<A> editLastVersion() {
        int index = this.versions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "versions"));
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public RelatedObjectsNested<A> editMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.relatedObjects.size(); ++i) {
            if (!predicate.test(this.relatedObjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "relatedObjects"));
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    public VersionsNested<A> editMatchingVersion(Predicate<OperandVersionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.versions.size(); ++i) {
            if (!predicate.test(this.versions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "versions"));
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    public RelatedObjectsNested<A> editRelatedObject(int index) {
        if (this.relatedObjects.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "relatedObjects"));
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    public VersionsNested<A> editVersion(int index) {
        if (this.versions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "versions"));
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterOperatorStatusFluent that = (ClusterOperatorStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.extension, that.extension)) {
            return false;
        }
        if (!Objects.equals(this.relatedObjects, that.relatedObjects)) {
            return false;
        }
        if (!Objects.equals(this.versions, that.versions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getExtension() {
        return this.extension;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasExtension() {
        return this.extension != null;
    }

    public boolean hasMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        for (ClusterOperatorStatusConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.relatedObjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingVersion(Predicate<OperandVersionBuilder> predicate) {
        for (OperandVersionBuilder item : this.versions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRelatedObjects() {
        return this.relatedObjects != null && !this.relatedObjects.isEmpty();
    }

    public boolean hasVersions() {
        return this.versions != null && !this.versions.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.extension, this.relatedObjects, this.versions, this.additionalProperties);
    }

    public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ClusterOperatorStatusCondition item : items) {
            ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRelatedObjects(Collection<ObjectReference> items) {
        if (this.relatedObjects == null) {
            return (A)((Object)this);
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"relatedObjects").remove((Object)builder);
            this.relatedObjects.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVersions(Collection<OperandVersion> items) {
        if (this.versions == null) {
            return (A)((Object)this);
        }
        for (OperandVersion item : items) {
            OperandVersionBuilder builder = new OperandVersionBuilder(item);
            this._visitables.get((Object)"versions").remove((Object)builder);
            this.versions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(ClusterOperatorStatusCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ClusterOperatorStatusCondition item : items) {
            ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRelatedObjects(ObjectReference ... items) {
        if (this.relatedObjects == null) {
            return (A)((Object)this);
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"relatedObjects").remove((Object)builder);
            this.relatedObjects.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVersions(OperandVersion ... items) {
        if (this.versions == null) {
            return (A)((Object)this);
        }
        for (OperandVersion item : items) {
            OperandVersionBuilder builder = new OperandVersionBuilder(item);
            this._visitables.get((Object)"versions").remove((Object)builder);
            this.versions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ClusterOperatorStatusConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ClusterOperatorStatusConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRelatedObjects(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.relatedObjects == null) {
            return (A)((Object)this);
        }
        Iterator<ObjectReferenceBuilder> each = this.relatedObjects.iterator();
        List visitables = this._visitables.get((Object)"relatedObjects");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVersions(Predicate<OperandVersionBuilder> predicate) {
        if (this.versions == null) {
            return (A)((Object)this);
        }
        Iterator<OperandVersionBuilder> each = this.versions.iterator();
        List visitables = this._visitables.get((Object)"versions");
        while (each.hasNext()) {
            OperandVersionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> setNewConditionLike(int index, ClusterOperatorStatusCondition item) {
        return new ConditionsNested(index, item);
    }

    public RelatedObjectsNested<A> setNewRelatedObjectLike(int index, ObjectReference item) {
        return new RelatedObjectsNested(index, item);
    }

    public VersionsNested<A> setNewVersionLike(int index, OperandVersion item) {
        return new VersionsNested(index, item);
    }

    public A setToConditions(int index, ClusterOperatorStatusCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRelatedObjects(int index, ObjectReference item) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.relatedObjects.size()) {
            this._visitables.get((Object)"relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        } else {
            this._visitables.get((Object)"relatedObjects").add(builder);
            this.relatedObjects.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVersions(int index, OperandVersion item) {
        if (this.versions == null) {
            this.versions = new ArrayList();
        }
        OperandVersionBuilder builder = new OperandVersionBuilder(item);
        if (index < 0 || index >= this.versions.size()) {
            this._visitables.get((Object)"versions").add(builder);
            this.versions.add(builder);
        } else {
            this._visitables.get((Object)"versions").add(builder);
            this.versions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.extension != null) {
            sb.append("extension:");
            sb.append(this.extension);
            sb.append(",");
        }
        if (this.relatedObjects != null && !this.relatedObjects.isEmpty()) {
            sb.append("relatedObjects:");
            sb.append(this.relatedObjects);
            sb.append(",");
        }
        if (this.versions != null && !this.versions.isEmpty()) {
            sb.append("versions:");
            sb.append(this.versions);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withConditions(List<ClusterOperatorStatusCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (ClusterOperatorStatusCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(ClusterOperatorStatusCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (ClusterOperatorStatusCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withExtension(Object extension) {
        this.extension = extension;
        return (A)((Object)this);
    }

    public A withRelatedObjects(List<ObjectReference> relatedObjects) {
        if (this.relatedObjects != null) {
            this._visitables.get((Object)"relatedObjects").clear();
        }
        if (relatedObjects != null) {
            this.relatedObjects = new ArrayList();
            for (ObjectReference item : relatedObjects) {
                this.addToRelatedObjects(item);
            }
        } else {
            this.relatedObjects = null;
        }
        return (A)((Object)this);
    }

    public A withRelatedObjects(ObjectReference ... relatedObjects) {
        if (this.relatedObjects != null) {
            this.relatedObjects.clear();
            this._visitables.remove((Object)"relatedObjects");
        }
        if (relatedObjects != null) {
            for (ObjectReference item : relatedObjects) {
                this.addToRelatedObjects(item);
            }
        }
        return (A)((Object)this);
    }

    public A withVersions(List<OperandVersion> versions) {
        if (this.versions != null) {
            this._visitables.get((Object)"versions").clear();
        }
        if (versions != null) {
            this.versions = new ArrayList();
            for (OperandVersion item : versions) {
                this.addToVersions(item);
            }
        } else {
            this.versions = null;
        }
        return (A)((Object)this);
    }

    public A withVersions(OperandVersion ... versions) {
        if (this.versions != null) {
            this.versions.clear();
            this._visitables.remove((Object)"versions");
        }
        if (versions != null) {
            for (OperandVersion item : versions) {
                this.addToVersions(item);
            }
        }
        return (A)((Object)this);
    }

    public class VersionsNested<N>
    extends OperandVersionFluent<VersionsNested<N>>
    implements Nested<N> {
        OperandVersionBuilder builder;
        int index;

        VersionsNested(int index, OperandVersion item) {
            this.index = index;
            this.builder = new OperandVersionBuilder(this, item);
        }

        public N and() {
            return (N)ClusterOperatorStatusFluent.this.setToVersions(this.index, this.builder.build());
        }

        public N endVersion() {
            return this.and();
        }
    }

    public class RelatedObjectsNested<N>
    extends ObjectReferenceFluent<RelatedObjectsNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;
        int index;

        RelatedObjectsNested(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)ClusterOperatorStatusFluent.this.setToRelatedObjects(this.index, this.builder.build());
        }

        public N endRelatedObject() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ClusterOperatorStatusConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ClusterOperatorStatusConditionBuilder builder;
        int index;

        ConditionsNested(int index, ClusterOperatorStatusCondition item) {
            this.index = index;
            this.builder = new ClusterOperatorStatusConditionBuilder(this, item);
        }

        public N and() {
            return (N)ClusterOperatorStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

