package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class WebhookTokenAuthenticatorFluent<A extends WebhookTokenAuthenticatorFluent<A>> extends BaseFluent<A>{
  public WebhookTokenAuthenticatorFluent() {
  }
  
  public WebhookTokenAuthenticatorFluent(WebhookTokenAuthenticator instance) {
    this.copyInstance(instance);
  }
  private SecretNameReferenceBuilder kubeConfig;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(WebhookTokenAuthenticator instance) {
    instance = (instance != null ? instance : new WebhookTokenAuthenticator());
    if (instance != null) {
          this.withKubeConfig(instance.getKubeConfig());
          this.withKubeConfig(instance.getKubeConfig());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SecretNameReference buildKubeConfig() {
    return this.kubeConfig != null ? this.kubeConfig.build() : null;
  }
  
  public A withKubeConfig(SecretNameReference kubeConfig) {
    this._visitables.remove(this.kubeConfig);
    if (kubeConfig != null) {
        this.kubeConfig = new SecretNameReferenceBuilder(kubeConfig);
        this._visitables.get("kubeConfig").add(this.kubeConfig);
    } else {
        this.kubeConfig = null;
        this._visitables.get("kubeConfig").remove(this.kubeConfig);
    }
    return (A) this;
  }
  
  public boolean hasKubeConfig() {
    return this.kubeConfig != null;
  }
  
  public A withNewKubeConfig(String name) {
    return (A)withKubeConfig(new SecretNameReference(name));
  }
  
  public KubeConfigNested<A> withNewKubeConfig() {
    return new KubeConfigNested(null);
  }
  
  public KubeConfigNested<A> withNewKubeConfigLike(SecretNameReference item) {
    return new KubeConfigNested(item);
  }
  
  public KubeConfigNested<A> editKubeConfig() {
    return withNewKubeConfigLike(java.util.Optional.ofNullable(buildKubeConfig()).orElse(null));
  }
  
  public KubeConfigNested<A> editOrNewKubeConfig() {
    return withNewKubeConfigLike(java.util.Optional.ofNullable(buildKubeConfig()).orElse(new SecretNameReferenceBuilder().build()));
  }
  
  public KubeConfigNested<A> editOrNewKubeConfigLike(SecretNameReference item) {
    return withNewKubeConfigLike(java.util.Optional.ofNullable(buildKubeConfig()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WebhookTokenAuthenticatorFluent that = (WebhookTokenAuthenticatorFluent) o;
    if (!java.util.Objects.equals(kubeConfig, that.kubeConfig)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(kubeConfig,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (kubeConfig != null) { sb.append("kubeConfig:"); sb.append(kubeConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class KubeConfigNested<N> extends SecretNameReferenceFluent<KubeConfigNested<N>> implements Nested<N>{
    KubeConfigNested(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    SecretNameReferenceBuilder builder;
    
    public N and() {
      return (N) WebhookTokenAuthenticatorFluent.this.withKubeConfig(builder.build());
    }
    
    public N endKubeConfig() {
      return and();
    }
    
  
  }

}