package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProjectStatusBuilder extends ProjectStatusFluent<ProjectStatusBuilder> implements VisitableBuilder<ProjectStatus,ProjectStatusBuilder>{
  public ProjectStatusBuilder() {
    this(new ProjectStatus());
  }
  
  public ProjectStatusBuilder(ProjectStatusFluent<?> fluent) {
    this(fluent, new ProjectStatus());
  }
  
  public ProjectStatusBuilder(ProjectStatusFluent<?> fluent,ProjectStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProjectStatusBuilder(ProjectStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProjectStatusFluent<?> fluent;
  
  public ProjectStatus build() {
    ProjectStatus buildable = new ProjectStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}