package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NutanixPlatformStatusBuilder extends NutanixPlatformStatusFluent<NutanixPlatformStatusBuilder> implements VisitableBuilder<NutanixPlatformStatus,NutanixPlatformStatusBuilder>{
  public NutanixPlatformStatusBuilder() {
    this(new NutanixPlatformStatus());
  }
  
  public NutanixPlatformStatusBuilder(NutanixPlatformStatusFluent<?> fluent) {
    this(fluent, new NutanixPlatformStatus());
  }
  
  public NutanixPlatformStatusBuilder(NutanixPlatformStatusFluent<?> fluent,NutanixPlatformStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NutanixPlatformStatusBuilder(NutanixPlatformStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NutanixPlatformStatusFluent<?> fluent;
  
  public NutanixPlatformStatus build() {
    NutanixPlatformStatus buildable = new NutanixPlatformStatus(fluent.getApiServerInternalIP(),fluent.getApiServerInternalIPs(),fluent.getIngressIP(),fluent.getIngressIPs(),fluent.buildLoadBalancer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}