package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class InfrastructureSpecFluent<A extends InfrastructureSpecFluent<A>> extends BaseFluent<A>{
  public InfrastructureSpecFluent() {
  }
  
  public InfrastructureSpecFluent(InfrastructureSpec instance) {
    this.copyInstance(instance);
  }
  private ConfigMapFileReferenceBuilder cloudConfig;
  private PlatformSpecBuilder platformSpec;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(InfrastructureSpec instance) {
    instance = (instance != null ? instance : new InfrastructureSpec());
    if (instance != null) {
          this.withCloudConfig(instance.getCloudConfig());
          this.withPlatformSpec(instance.getPlatformSpec());
          this.withCloudConfig(instance.getCloudConfig());
          this.withPlatformSpec(instance.getPlatformSpec());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ConfigMapFileReference buildCloudConfig() {
    return this.cloudConfig != null ? this.cloudConfig.build() : null;
  }
  
  public A withCloudConfig(ConfigMapFileReference cloudConfig) {
    this._visitables.remove(this.cloudConfig);
    if (cloudConfig != null) {
        this.cloudConfig = new ConfigMapFileReferenceBuilder(cloudConfig);
        this._visitables.get("cloudConfig").add(this.cloudConfig);
    } else {
        this.cloudConfig = null;
        this._visitables.get("cloudConfig").remove(this.cloudConfig);
    }
    return (A) this;
  }
  
  public boolean hasCloudConfig() {
    return this.cloudConfig != null;
  }
  
  public A withNewCloudConfig(String key,String name) {
    return (A)withCloudConfig(new ConfigMapFileReference(key, name));
  }
  
  public CloudConfigNested<A> withNewCloudConfig() {
    return new CloudConfigNested(null);
  }
  
  public CloudConfigNested<A> withNewCloudConfigLike(ConfigMapFileReference item) {
    return new CloudConfigNested(item);
  }
  
  public CloudConfigNested<A> editCloudConfig() {
    return withNewCloudConfigLike(java.util.Optional.ofNullable(buildCloudConfig()).orElse(null));
  }
  
  public CloudConfigNested<A> editOrNewCloudConfig() {
    return withNewCloudConfigLike(java.util.Optional.ofNullable(buildCloudConfig()).orElse(new ConfigMapFileReferenceBuilder().build()));
  }
  
  public CloudConfigNested<A> editOrNewCloudConfigLike(ConfigMapFileReference item) {
    return withNewCloudConfigLike(java.util.Optional.ofNullable(buildCloudConfig()).orElse(item));
  }
  
  public PlatformSpec buildPlatformSpec() {
    return this.platformSpec != null ? this.platformSpec.build() : null;
  }
  
  public A withPlatformSpec(PlatformSpec platformSpec) {
    this._visitables.remove(this.platformSpec);
    if (platformSpec != null) {
        this.platformSpec = new PlatformSpecBuilder(platformSpec);
        this._visitables.get("platformSpec").add(this.platformSpec);
    } else {
        this.platformSpec = null;
        this._visitables.get("platformSpec").remove(this.platformSpec);
    }
    return (A) this;
  }
  
  public boolean hasPlatformSpec() {
    return this.platformSpec != null;
  }
  
  public PlatformSpecNested<A> withNewPlatformSpec() {
    return new PlatformSpecNested(null);
  }
  
  public PlatformSpecNested<A> withNewPlatformSpecLike(PlatformSpec item) {
    return new PlatformSpecNested(item);
  }
  
  public PlatformSpecNested<A> editPlatformSpec() {
    return withNewPlatformSpecLike(java.util.Optional.ofNullable(buildPlatformSpec()).orElse(null));
  }
  
  public PlatformSpecNested<A> editOrNewPlatformSpec() {
    return withNewPlatformSpecLike(java.util.Optional.ofNullable(buildPlatformSpec()).orElse(new PlatformSpecBuilder().build()));
  }
  
  public PlatformSpecNested<A> editOrNewPlatformSpecLike(PlatformSpec item) {
    return withNewPlatformSpecLike(java.util.Optional.ofNullable(buildPlatformSpec()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InfrastructureSpecFluent that = (InfrastructureSpecFluent) o;
    if (!java.util.Objects.equals(cloudConfig, that.cloudConfig)) return false;
    if (!java.util.Objects.equals(platformSpec, that.platformSpec)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cloudConfig,  platformSpec,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cloudConfig != null) { sb.append("cloudConfig:"); sb.append(cloudConfig + ","); }
    if (platformSpec != null) { sb.append("platformSpec:"); sb.append(platformSpec + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CloudConfigNested<N> extends ConfigMapFileReferenceFluent<CloudConfigNested<N>> implements Nested<N>{
    CloudConfigNested(ConfigMapFileReference item) {
      this.builder = new ConfigMapFileReferenceBuilder(this, item);
    }
    ConfigMapFileReferenceBuilder builder;
    
    public N and() {
      return (N) InfrastructureSpecFluent.this.withCloudConfig(builder.build());
    }
    
    public N endCloudConfig() {
      return and();
    }
    
  
  }
  public class PlatformSpecNested<N> extends PlatformSpecFluent<PlatformSpecNested<N>> implements Nested<N>{
    PlatformSpecNested(PlatformSpec item) {
      this.builder = new PlatformSpecBuilder(this, item);
    }
    PlatformSpecBuilder builder;
    
    public N and() {
      return (N) InfrastructureSpecFluent.this.withPlatformSpec(builder.build());
    }
    
    public N endPlatformSpec() {
      return and();
    }
    
  
  }

}