package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CustomTLSProfileFluent<A extends CustomTLSProfileFluent<A>> extends BaseFluent<A>{
  public CustomTLSProfileFluent() {
  }
  
  public CustomTLSProfileFluent(CustomTLSProfile instance) {
    this.copyInstance(instance);
  }
  private List<String> ciphers = new ArrayList<String>();
  private String minTLSVersion;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CustomTLSProfile instance) {
    instance = (instance != null ? instance : new CustomTLSProfile());
    if (instance != null) {
          this.withCiphers(instance.getCiphers());
          this.withMinTLSVersion(instance.getMinTLSVersion());
          this.withCiphers(instance.getCiphers());
          this.withMinTLSVersion(instance.getMinTLSVersion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToCiphers(int index,String item) {
    if (this.ciphers == null) {this.ciphers = new ArrayList<String>();}
    this.ciphers.add(index, item);
    return (A)this;
  }
  
  public A setToCiphers(int index,String item) {
    if (this.ciphers == null) {this.ciphers = new ArrayList<String>();}
    this.ciphers.set(index, item); return (A)this;
  }
  
  public A addToCiphers(java.lang.String... items) {
    if (this.ciphers == null) {this.ciphers = new ArrayList<String>();}
    for (String item : items) {this.ciphers.add(item);} return (A)this;
  }
  
  public A addAllToCiphers(Collection<String> items) {
    if (this.ciphers == null) {this.ciphers = new ArrayList<String>();}
    for (String item : items) {this.ciphers.add(item);} return (A)this;
  }
  
  public A removeFromCiphers(java.lang.String... items) {
    if (this.ciphers == null) return (A)this;
    for (String item : items) { this.ciphers.remove(item);} return (A)this;
  }
  
  public A removeAllFromCiphers(Collection<String> items) {
    if (this.ciphers == null) return (A)this;
    for (String item : items) { this.ciphers.remove(item);} return (A)this;
  }
  
  public List<String> getCiphers() {
    return this.ciphers;
  }
  
  public String getCipher(int index) {
    return this.ciphers.get(index);
  }
  
  public String getFirstCipher() {
    return this.ciphers.get(0);
  }
  
  public String getLastCipher() {
    return this.ciphers.get(ciphers.size() - 1);
  }
  
  public String getMatchingCipher(Predicate<String> predicate) {
      for (String item : ciphers) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCipher(Predicate<String> predicate) {
      for (String item : ciphers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCiphers(List<String> ciphers) {
    if (ciphers != null) {
        this.ciphers = new ArrayList();
        for (String item : ciphers) {
          this.addToCiphers(item);
        }
    } else {
      this.ciphers = null;
    }
    return (A) this;
  }
  
  public A withCiphers(java.lang.String... ciphers) {
    if (this.ciphers != null) {this.ciphers.clear(); _visitables.remove("ciphers"); }
    if (ciphers != null) {for (String item :ciphers){ this.addToCiphers(item);}} return (A) this;
  }
  
  public boolean hasCiphers() {
    return this.ciphers != null && !this.ciphers.isEmpty();
  }
  
  public String getMinTLSVersion() {
    return this.minTLSVersion;
  }
  
  public A withMinTLSVersion(String minTLSVersion) {
    this.minTLSVersion = minTLSVersion;
    return (A) this;
  }
  
  public boolean hasMinTLSVersion() {
    return this.minTLSVersion != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CustomTLSProfileFluent that = (CustomTLSProfileFluent) o;
    if (!java.util.Objects.equals(ciphers, that.ciphers)) return false;
    if (!java.util.Objects.equals(minTLSVersion, that.minTLSVersion)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ciphers,  minTLSVersion,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ciphers != null && !ciphers.isEmpty()) { sb.append("ciphers:"); sb.append(ciphers + ","); }
    if (minTLSVersion != null) { sb.append("minTLSVersion:"); sb.append(minTLSVersion + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}