package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NutanixPrismElementEndpointFluent<A extends NutanixPrismElementEndpointFluent<A>> extends BaseFluent<A>{
  public NutanixPrismElementEndpointFluent() {
  }
  
  public NutanixPrismElementEndpointFluent(NutanixPrismElementEndpoint instance) {
    this.copyInstance(instance);
  }
  private NutanixPrismEndpointBuilder endpoint;
  private String name;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NutanixPrismElementEndpoint instance) {
    instance = (instance != null ? instance : new NutanixPrismElementEndpoint());
  
    if (instance != null) {
        this.withEndpoint(instance.getEndpoint());
        this.withName(instance.getName());
        this.withEndpoint(instance.getEndpoint());
        this.withName(instance.getName());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public NutanixPrismEndpoint buildEndpoint() {
    return this.endpoint!=null ?this.endpoint.build():null;
  }
  
  public A withEndpoint(NutanixPrismEndpoint endpoint) {
    _visitables.get("endpoint").remove(this.endpoint);
    if (endpoint!=null){ this.endpoint= new NutanixPrismEndpointBuilder(endpoint); _visitables.get("endpoint").add(this.endpoint);} else { this.endpoint = null; _visitables.get("endpoint").remove(this.endpoint); } return (A) this;
  }
  
  public boolean hasEndpoint() {
    return this.endpoint != null;
  }
  
  public A withNewEndpoint(String address,Integer port) {
    return (A)withEndpoint(new NutanixPrismEndpoint(address, port));
  }
  
  public EndpointNested<A> withNewEndpoint() {
    return new EndpointNested(null);
  }
  
  public EndpointNested<A> withNewEndpointLike(NutanixPrismEndpoint item) {
    return new EndpointNested(item);
  }
  
  public EndpointNested<A> editEndpoint() {
    return withNewEndpointLike(java.util.Optional.ofNullable(buildEndpoint()).orElse(null));
  }
  
  public EndpointNested<A> editOrNewEndpoint() {
    return withNewEndpointLike(java.util.Optional.ofNullable(buildEndpoint()).orElse(new NutanixPrismEndpointBuilder().build()));
  }
  
  public EndpointNested<A> editOrNewEndpointLike(NutanixPrismEndpoint item) {
    return withNewEndpointLike(java.util.Optional.ofNullable(buildEndpoint()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NutanixPrismElementEndpointFluent that = (NutanixPrismElementEndpointFluent) o;
    if (!java.util.Objects.equals(endpoint, that.endpoint)) return false;
  
    if (!java.util.Objects.equals(name, that.name)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(endpoint,  name,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (endpoint != null) { sb.append("endpoint:"); sb.append(endpoint + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EndpointNested<N> extends NutanixPrismEndpointFluent<EndpointNested<N>> implements Nested<N>{
    EndpointNested(NutanixPrismEndpoint item) {
      this.builder = new NutanixPrismEndpointBuilder(this, item);
    }
    NutanixPrismEndpointBuilder builder;
    
    public N and() {
      return (N) NutanixPrismElementEndpointFluent.this.withEndpoint(builder.build());
    }
    
    public N endEndpoint() {
      return and();
    }
    
  
  }

}