package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NutanixPlatformSpecFluent<A extends NutanixPlatformSpecFluent<A>> extends BaseFluent<A>{
  public NutanixPlatformSpecFluent() {
  }
  
  public NutanixPlatformSpecFluent(NutanixPlatformSpec instance) {
    this.copyInstance(instance);
  }
  private NutanixPrismEndpointBuilder prismCentral;
  private ArrayList<NutanixPrismElementEndpointBuilder> prismElements = new ArrayList<NutanixPrismElementEndpointBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NutanixPlatformSpec instance) {
    instance = (instance != null ? instance : new NutanixPlatformSpec());
  
    if (instance != null) {
        this.withPrismCentral(instance.getPrismCentral());
        this.withPrismElements(instance.getPrismElements());
        this.withPrismCentral(instance.getPrismCentral());
        this.withPrismElements(instance.getPrismElements());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public NutanixPrismEndpoint buildPrismCentral() {
    return this.prismCentral!=null ?this.prismCentral.build():null;
  }
  
  public A withPrismCentral(NutanixPrismEndpoint prismCentral) {
    _visitables.get("prismCentral").remove(this.prismCentral);
    if (prismCentral!=null){ this.prismCentral= new NutanixPrismEndpointBuilder(prismCentral); _visitables.get("prismCentral").add(this.prismCentral);} else { this.prismCentral = null; _visitables.get("prismCentral").remove(this.prismCentral); } return (A) this;
  }
  
  public boolean hasPrismCentral() {
    return this.prismCentral != null;
  }
  
  public A withNewPrismCentral(String address,Integer port) {
    return (A)withPrismCentral(new NutanixPrismEndpoint(address, port));
  }
  
  public PrismCentralNested<A> withNewPrismCentral() {
    return new PrismCentralNested(null);
  }
  
  public PrismCentralNested<A> withNewPrismCentralLike(NutanixPrismEndpoint item) {
    return new PrismCentralNested(item);
  }
  
  public PrismCentralNested<A> editPrismCentral() {
    return withNewPrismCentralLike(java.util.Optional.ofNullable(buildPrismCentral()).orElse(null));
  }
  
  public PrismCentralNested<A> editOrNewPrismCentral() {
    return withNewPrismCentralLike(java.util.Optional.ofNullable(buildPrismCentral()).orElse(new NutanixPrismEndpointBuilder().build()));
  }
  
  public PrismCentralNested<A> editOrNewPrismCentralLike(NutanixPrismEndpoint item) {
    return withNewPrismCentralLike(java.util.Optional.ofNullable(buildPrismCentral()).orElse(item));
  }
  
  public A addToPrismElements(int index,NutanixPrismElementEndpoint item) {
    if (this.prismElements == null) {this.prismElements = new ArrayList<NutanixPrismElementEndpointBuilder>();}
    NutanixPrismElementEndpointBuilder builder = new NutanixPrismElementEndpointBuilder(item);
    if (index < 0 || index >= prismElements.size()) { _visitables.get("prismElements").add(builder); prismElements.add(builder); } else { _visitables.get("prismElements").add(index, builder); prismElements.add(index, builder);}
    return (A)this;
  }
  
  public A setToPrismElements(int index,NutanixPrismElementEndpoint item) {
    if (this.prismElements == null) {this.prismElements = new ArrayList<NutanixPrismElementEndpointBuilder>();}
    NutanixPrismElementEndpointBuilder builder = new NutanixPrismElementEndpointBuilder(item);
    if (index < 0 || index >= prismElements.size()) { _visitables.get("prismElements").add(builder); prismElements.add(builder); } else { _visitables.get("prismElements").set(index, builder); prismElements.set(index, builder);}
    return (A)this;
  }
  
  public A addToPrismElements(io.fabric8.openshift.api.model.config.v1.NutanixPrismElementEndpoint... items) {
    if (this.prismElements == null) {this.prismElements = new ArrayList<NutanixPrismElementEndpointBuilder>();}
    for (NutanixPrismElementEndpoint item : items) {NutanixPrismElementEndpointBuilder builder = new NutanixPrismElementEndpointBuilder(item);_visitables.get("prismElements").add(builder);this.prismElements.add(builder);} return (A)this;
  }
  
  public A addAllToPrismElements(Collection<NutanixPrismElementEndpoint> items) {
    if (this.prismElements == null) {this.prismElements = new ArrayList<NutanixPrismElementEndpointBuilder>();}
    for (NutanixPrismElementEndpoint item : items) {NutanixPrismElementEndpointBuilder builder = new NutanixPrismElementEndpointBuilder(item);_visitables.get("prismElements").add(builder);this.prismElements.add(builder);} return (A)this;
  }
  
  public A removeFromPrismElements(io.fabric8.openshift.api.model.config.v1.NutanixPrismElementEndpoint... items) {
    if (this.prismElements == null) return (A)this;
    for (NutanixPrismElementEndpoint item : items) {NutanixPrismElementEndpointBuilder builder = new NutanixPrismElementEndpointBuilder(item);_visitables.get("prismElements").remove(builder); this.prismElements.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPrismElements(Collection<NutanixPrismElementEndpoint> items) {
    if (this.prismElements == null) return (A)this;
    for (NutanixPrismElementEndpoint item : items) {NutanixPrismElementEndpointBuilder builder = new NutanixPrismElementEndpointBuilder(item);_visitables.get("prismElements").remove(builder); this.prismElements.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPrismElements(Predicate<NutanixPrismElementEndpointBuilder> predicate) {
    if (prismElements == null) return (A) this;
    final Iterator<NutanixPrismElementEndpointBuilder> each = prismElements.iterator();
    final List visitables = _visitables.get("prismElements");
    while (each.hasNext()) {
      NutanixPrismElementEndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NutanixPrismElementEndpoint> buildPrismElements() {
    return prismElements != null ? build(prismElements) : null;
  }
  
  public NutanixPrismElementEndpoint buildPrismElement(int index) {
    return this.prismElements.get(index).build();
  }
  
  public NutanixPrismElementEndpoint buildFirstPrismElement() {
    return this.prismElements.get(0).build();
  }
  
  public NutanixPrismElementEndpoint buildLastPrismElement() {
    return this.prismElements.get(prismElements.size() - 1).build();
  }
  
  public NutanixPrismElementEndpoint buildMatchingPrismElement(Predicate<NutanixPrismElementEndpointBuilder> predicate) {
    for (NutanixPrismElementEndpointBuilder item: prismElements) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingPrismElement(Predicate<NutanixPrismElementEndpointBuilder> predicate) {
    for (NutanixPrismElementEndpointBuilder item: prismElements) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withPrismElements(List<NutanixPrismElementEndpoint> prismElements) {
    if (this.prismElements != null) { _visitables.get("prismElements").clear();}
    if (prismElements != null) {this.prismElements = new ArrayList(); for (NutanixPrismElementEndpoint item : prismElements){this.addToPrismElements(item);}} else { this.prismElements = null;} return (A) this;
  }
  
  public A withPrismElements(io.fabric8.openshift.api.model.config.v1.NutanixPrismElementEndpoint... prismElements) {
    if (this.prismElements != null) {this.prismElements.clear(); _visitables.remove("prismElements"); }
    if (prismElements != null) {for (NutanixPrismElementEndpoint item :prismElements){ this.addToPrismElements(item);}} return (A) this;
  }
  
  public boolean hasPrismElements() {
    return prismElements != null && !prismElements.isEmpty();
  }
  
  public PrismElementsNested<A> addNewPrismElement() {
    return new PrismElementsNested(-1, null);
  }
  
  public PrismElementsNested<A> addNewPrismElementLike(NutanixPrismElementEndpoint item) {
    return new PrismElementsNested(-1, item);
  }
  
  public PrismElementsNested<A> setNewPrismElementLike(int index,NutanixPrismElementEndpoint item) {
    return new PrismElementsNested(index, item);
  }
  
  public PrismElementsNested<A> editPrismElement(int index) {
    if (prismElements.size() <= index) throw new RuntimeException("Can't edit prismElements. Index exceeds size.");
    return setNewPrismElementLike(index, buildPrismElement(index));
  }
  
  public PrismElementsNested<A> editFirstPrismElement() {
    if (prismElements.size() == 0) throw new RuntimeException("Can't edit first prismElements. The list is empty.");
    return setNewPrismElementLike(0, buildPrismElement(0));
  }
  
  public PrismElementsNested<A> editLastPrismElement() {
    int index = prismElements.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last prismElements. The list is empty.");
    return setNewPrismElementLike(index, buildPrismElement(index));
  }
  
  public PrismElementsNested<A> editMatchingPrismElement(Predicate<NutanixPrismElementEndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<prismElements.size();i++) { 
    if (predicate.test(prismElements.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching prismElements. No match found.");
    return setNewPrismElementLike(index, buildPrismElement(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NutanixPlatformSpecFluent that = (NutanixPlatformSpecFluent) o;
    if (!java.util.Objects.equals(prismCentral, that.prismCentral)) return false;
  
    if (!java.util.Objects.equals(prismElements, that.prismElements)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(prismCentral,  prismElements,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (prismCentral != null) { sb.append("prismCentral:"); sb.append(prismCentral + ","); }
    if (prismElements != null && !prismElements.isEmpty()) { sb.append("prismElements:"); sb.append(prismElements + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PrismCentralNested<N> extends NutanixPrismEndpointFluent<PrismCentralNested<N>> implements Nested<N>{
    PrismCentralNested(NutanixPrismEndpoint item) {
      this.builder = new NutanixPrismEndpointBuilder(this, item);
    }
    NutanixPrismEndpointBuilder builder;
    
    public N and() {
      return (N) NutanixPlatformSpecFluent.this.withPrismCentral(builder.build());
    }
    
    public N endPrismCentral() {
      return and();
    }
    
  
  }
  public class PrismElementsNested<N> extends NutanixPrismElementEndpointFluent<PrismElementsNested<N>> implements Nested<N>{
    PrismElementsNested(int index,NutanixPrismElementEndpoint item) {
      this.index = index;
      this.builder = new NutanixPrismElementEndpointBuilder(this, item);
    }
    NutanixPrismElementEndpointBuilder builder;
    int index;
    
    public N and() {
      return (N) NutanixPlatformSpecFluent.this.setToPrismElements(index,builder.build());
    }
    
    public N endPrismElement() {
      return and();
    }
    
  
  }

}