package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkMigrationFluent<A extends NetworkMigrationFluent<A>> extends BaseFluent<A>{
  public NetworkMigrationFluent() {
  }
  
  public NetworkMigrationFluent(NetworkMigration instance) {
    this.copyInstance(instance);
  }
  private MTUMigrationBuilder mtu;
  private String networkType;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkMigration instance) {
    instance = (instance != null ? instance : new NetworkMigration());
  
    if (instance != null) {
        this.withMtu(instance.getMtu());
        this.withNetworkType(instance.getNetworkType());
        this.withMtu(instance.getMtu());
        this.withNetworkType(instance.getNetworkType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public MTUMigration buildMtu() {
    return this.mtu!=null ?this.mtu.build():null;
  }
  
  public A withMtu(MTUMigration mtu) {
    _visitables.get("mtu").remove(this.mtu);
    if (mtu!=null){ this.mtu= new MTUMigrationBuilder(mtu); _visitables.get("mtu").add(this.mtu);} else { this.mtu = null; _visitables.get("mtu").remove(this.mtu); } return (A) this;
  }
  
  public boolean hasMtu() {
    return this.mtu != null;
  }
  
  public MtuNested<A> withNewMtu() {
    return new MtuNested(null);
  }
  
  public MtuNested<A> withNewMtuLike(MTUMigration item) {
    return new MtuNested(item);
  }
  
  public MtuNested<A> editMtu() {
    return withNewMtuLike(java.util.Optional.ofNullable(buildMtu()).orElse(null));
  }
  
  public MtuNested<A> editOrNewMtu() {
    return withNewMtuLike(java.util.Optional.ofNullable(buildMtu()).orElse(new MTUMigrationBuilder().build()));
  }
  
  public MtuNested<A> editOrNewMtuLike(MTUMigration item) {
    return withNewMtuLike(java.util.Optional.ofNullable(buildMtu()).orElse(item));
  }
  
  public String getNetworkType() {
    return this.networkType;
  }
  
  public A withNetworkType(String networkType) {
    this.networkType=networkType; return (A) this;
  }
  
  public boolean hasNetworkType() {
    return this.networkType != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkMigrationFluent that = (NetworkMigrationFluent) o;
    if (!java.util.Objects.equals(mtu, that.mtu)) return false;
  
    if (!java.util.Objects.equals(networkType, that.networkType)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(mtu,  networkType,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mtu != null) { sb.append("mtu:"); sb.append(mtu + ","); }
    if (networkType != null) { sb.append("networkType:"); sb.append(networkType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MtuNested<N> extends MTUMigrationFluent<MtuNested<N>> implements Nested<N>{
    MtuNested(MTUMigration item) {
      this.builder = new MTUMigrationBuilder(this, item);
    }
    MTUMigrationBuilder builder;
    
    public N and() {
      return (N) NetworkMigrationFluent.this.withMtu(builder.build());
    }
    
    public N endMtu() {
      return and();
    }
    
  
  }

}