package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HubSourceStatusFluent<A extends HubSourceStatusFluent<A>> extends BaseFluent<A>{
  public HubSourceStatusFluent() {
  }
  
  public HubSourceStatusFluent(HubSourceStatus instance) {
    this.copyInstance(instance);
  }
  private Boolean disabled;
  private String message;
  private String name;
  private String status;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HubSourceStatus instance) {
    instance = (instance != null ? instance : new HubSourceStatus());
  
    if (instance != null) {
        this.withDisabled(instance.getDisabled());
        this.withMessage(instance.getMessage());
        this.withName(instance.getName());
        this.withStatus(instance.getStatus());
        this.withDisabled(instance.getDisabled());
        this.withMessage(instance.getMessage());
        this.withName(instance.getName());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public Boolean getDisabled() {
    return this.disabled;
  }
  
  public A withDisabled(Boolean disabled) {
    this.disabled=disabled; return (A) this;
  }
  
  public boolean hasDisabled() {
    return this.disabled != null;
  }
  
  public String getMessage() {
    return this.message;
  }
  
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  
  public boolean hasMessage() {
    return this.message != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getStatus() {
    return this.status;
  }
  
  public A withStatus(String status) {
    this.status=status; return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HubSourceStatusFluent that = (HubSourceStatusFluent) o;
    if (!java.util.Objects.equals(disabled, that.disabled)) return false;
  
    if (!java.util.Objects.equals(message, that.message)) return false;
  
    if (!java.util.Objects.equals(name, that.name)) return false;
  
    if (!java.util.Objects.equals(status, that.status)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(disabled,  message,  name,  status,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (disabled != null) { sb.append("disabled:"); sb.append(disabled + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDisabled() {
    return withDisabled(true);
  }
  

}