package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ExternalIPPolicyFluent<A extends ExternalIPPolicyFluent<A>> extends BaseFluent<A>{
  public ExternalIPPolicyFluent() {
  }
  
  public ExternalIPPolicyFluent(ExternalIPPolicy instance) {
    this.copyInstance(instance);
  }
  private List<String> allowedCIDRs = new ArrayList<String>();
  private List<String> rejectedCIDRs = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ExternalIPPolicy instance) {
    instance = (instance != null ? instance : new ExternalIPPolicy());
  
    if (instance != null) {
        this.withAllowedCIDRs(instance.getAllowedCIDRs());
        this.withRejectedCIDRs(instance.getRejectedCIDRs());
        this.withAllowedCIDRs(instance.getAllowedCIDRs());
        this.withRejectedCIDRs(instance.getRejectedCIDRs());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToAllowedCIDRs(int index,String item) {
    if (this.allowedCIDRs == null) {this.allowedCIDRs = new ArrayList<String>();}
    this.allowedCIDRs.add(index, item);
    return (A)this;
  }
  
  public A setToAllowedCIDRs(int index,String item) {
    if (this.allowedCIDRs == null) {this.allowedCIDRs = new ArrayList<String>();}
    this.allowedCIDRs.set(index, item); return (A)this;
  }
  
  public A addToAllowedCIDRs(java.lang.String... items) {
    if (this.allowedCIDRs == null) {this.allowedCIDRs = new ArrayList<String>();}
    for (String item : items) {this.allowedCIDRs.add(item);} return (A)this;
  }
  
  public A addAllToAllowedCIDRs(Collection<String> items) {
    if (this.allowedCIDRs == null) {this.allowedCIDRs = new ArrayList<String>();}
    for (String item : items) {this.allowedCIDRs.add(item);} return (A)this;
  }
  
  public A removeFromAllowedCIDRs(java.lang.String... items) {
    if (this.allowedCIDRs == null) return (A)this;
    for (String item : items) { this.allowedCIDRs.remove(item);} return (A)this;
  }
  
  public A removeAllFromAllowedCIDRs(Collection<String> items) {
    if (this.allowedCIDRs == null) return (A)this;
    for (String item : items) { this.allowedCIDRs.remove(item);} return (A)this;
  }
  
  public List<String> getAllowedCIDRs() {
    return this.allowedCIDRs;
  }
  
  public String getAllowedCIDR(int index) {
    return this.allowedCIDRs.get(index);
  }
  
  public String getFirstAllowedCIDR() {
    return this.allowedCIDRs.get(0);
  }
  
  public String getLastAllowedCIDR() {
    return this.allowedCIDRs.get(allowedCIDRs.size() - 1);
  }
  
  public String getMatchingAllowedCIDR(Predicate<String> predicate) {
    for (String item: allowedCIDRs) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingAllowedCIDR(Predicate<String> predicate) {
    for (String item: allowedCIDRs) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withAllowedCIDRs(List<String> allowedCIDRs) {
    if (allowedCIDRs != null) {this.allowedCIDRs = new ArrayList(); for (String item : allowedCIDRs){this.addToAllowedCIDRs(item);}} else { this.allowedCIDRs = null;} return (A) this;
  }
  
  public A withAllowedCIDRs(java.lang.String... allowedCIDRs) {
    if (this.allowedCIDRs != null) {this.allowedCIDRs.clear(); _visitables.remove("allowedCIDRs"); }
    if (allowedCIDRs != null) {for (String item :allowedCIDRs){ this.addToAllowedCIDRs(item);}} return (A) this;
  }
  
  public boolean hasAllowedCIDRs() {
    return allowedCIDRs != null && !allowedCIDRs.isEmpty();
  }
  
  public A addToRejectedCIDRs(int index,String item) {
    if (this.rejectedCIDRs == null) {this.rejectedCIDRs = new ArrayList<String>();}
    this.rejectedCIDRs.add(index, item);
    return (A)this;
  }
  
  public A setToRejectedCIDRs(int index,String item) {
    if (this.rejectedCIDRs == null) {this.rejectedCIDRs = new ArrayList<String>();}
    this.rejectedCIDRs.set(index, item); return (A)this;
  }
  
  public A addToRejectedCIDRs(java.lang.String... items) {
    if (this.rejectedCIDRs == null) {this.rejectedCIDRs = new ArrayList<String>();}
    for (String item : items) {this.rejectedCIDRs.add(item);} return (A)this;
  }
  
  public A addAllToRejectedCIDRs(Collection<String> items) {
    if (this.rejectedCIDRs == null) {this.rejectedCIDRs = new ArrayList<String>();}
    for (String item : items) {this.rejectedCIDRs.add(item);} return (A)this;
  }
  
  public A removeFromRejectedCIDRs(java.lang.String... items) {
    if (this.rejectedCIDRs == null) return (A)this;
    for (String item : items) { this.rejectedCIDRs.remove(item);} return (A)this;
  }
  
  public A removeAllFromRejectedCIDRs(Collection<String> items) {
    if (this.rejectedCIDRs == null) return (A)this;
    for (String item : items) { this.rejectedCIDRs.remove(item);} return (A)this;
  }
  
  public List<String> getRejectedCIDRs() {
    return this.rejectedCIDRs;
  }
  
  public String getRejectedCIDR(int index) {
    return this.rejectedCIDRs.get(index);
  }
  
  public String getFirstRejectedCIDR() {
    return this.rejectedCIDRs.get(0);
  }
  
  public String getLastRejectedCIDR() {
    return this.rejectedCIDRs.get(rejectedCIDRs.size() - 1);
  }
  
  public String getMatchingRejectedCIDR(Predicate<String> predicate) {
    for (String item: rejectedCIDRs) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingRejectedCIDR(Predicate<String> predicate) {
    for (String item: rejectedCIDRs) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withRejectedCIDRs(List<String> rejectedCIDRs) {
    if (rejectedCIDRs != null) {this.rejectedCIDRs = new ArrayList(); for (String item : rejectedCIDRs){this.addToRejectedCIDRs(item);}} else { this.rejectedCIDRs = null;} return (A) this;
  }
  
  public A withRejectedCIDRs(java.lang.String... rejectedCIDRs) {
    if (this.rejectedCIDRs != null) {this.rejectedCIDRs.clear(); _visitables.remove("rejectedCIDRs"); }
    if (rejectedCIDRs != null) {for (String item :rejectedCIDRs){ this.addToRejectedCIDRs(item);}} return (A) this;
  }
  
  public boolean hasRejectedCIDRs() {
    return rejectedCIDRs != null && !rejectedCIDRs.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ExternalIPPolicyFluent that = (ExternalIPPolicyFluent) o;
    if (!java.util.Objects.equals(allowedCIDRs, that.allowedCIDRs)) return false;
  
    if (!java.util.Objects.equals(rejectedCIDRs, that.rejectedCIDRs)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allowedCIDRs,  rejectedCIDRs,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowedCIDRs != null && !allowedCIDRs.isEmpty()) { sb.append("allowedCIDRs:"); sb.append(allowedCIDRs + ","); }
    if (rejectedCIDRs != null && !rejectedCIDRs.isEmpty()) { sb.append("rejectedCIDRs:"); sb.append(rejectedCIDRs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}